/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Annotation;
import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.ValidationContext;
import java.util.List;

class UnevaluatedPropertiesValidator
implements Applicator {
    private final String schemaRef;
    private final String parentPath;

    UnevaluatedPropertiesValidator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        String schemaPointer = node.getJsonPointer();
        this.schemaRef = ctx.getAbsoluteUri(schemaPointer);
        this.parentPath = schemaPointer.substring(0, schemaPointer.lastIndexOf(47));
    }

    @Override
    public boolean apply(ValidationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return true;
        }
        Schema schema = ctx.resolveRequiredSchema(this.schemaRef);
        List<Annotation> annotations = ctx.getAnnotations().stream().filter(a -> a.header().evaluationPath().startsWith(this.parentPath)).toList();
        return node.asObject().values().stream().filter(propertyNode -> annotations.stream().noneMatch(a -> a.header().instanceLocation().startsWith(propertyNode.getJsonPointer()))).allMatch(propertyNode -> schema.validate(ctx, (JsonNode)propertyNode));
    }

    @Override
    public int getOrder() {
        return 20;
    }
}

