/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SimpleType;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;
import java.util.Set;
import java.util.stream.Collectors;

class TypeValidator
implements Validator {
    private final Set<SimpleType> types;

    TypeValidator(JsonNode node) {
        if (!node.isString() && !node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.types = node.isString() ? Set.of(SimpleType.fromName(node.asString())) : node.asArray().stream().map(JsonNode::asString).map(SimpleType::fromName).collect(Collectors.toSet());
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode node) {
        SimpleType nodeType = node.getNodeType();
        if (this.types.contains((Object)nodeType) || nodeType == SimpleType.INTEGER && this.types.contains((Object)SimpleType.NUMBER)) {
            return ValidationResult.success();
        }
        return ValidationResult.failure("Value is [%s] but should be [%s]".formatted(nodeType.getName(), this.types));
    }
}

