/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.UriUtil;
import dev.harrel.jsonschema.ValidatorWrapper;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class SchemaRegistry {
    private final Map<String, Schema> schemas = new HashMap<String, Schema>();
    private final Map<String, Schema> additionalSchemas = new HashMap<String, Schema>();
    private final Map<String, Schema> dynamicSchemas = new HashMap<String, Schema>();

    SchemaRegistry() {
    }

    Schema get(String uri) {
        return this.schemas.getOrDefault(uri, this.additionalSchemas.get(uri));
    }

    Schema getDynamic(String anchor) {
        return this.dynamicSchemas.get(anchor);
    }

    void registerSchema(SchemaParsingContext ctx, JsonNode schemaNode, List<ValidatorWrapper> validators) {
        Schema schema = new Schema(ctx.getParentUri(), ctx.getAbsoluteUri(schemaNode), validators);
        this.schemas.put(ctx.getAbsoluteUri(schemaNode), schema);
        this.registerAnchorsIfPresent(ctx, schemaNode, schema);
    }

    void registerIdentifiableSchema(SchemaParsingContext ctx, URI id, JsonNode schemaNode, List<ValidatorWrapper> validators) {
        String absoluteUri = ctx.getAbsoluteUri(schemaNode);
        this.schemas.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(absoluteUri)).forEach(e -> {
            int normalizedUriSize = absoluteUri.endsWith("/") ? absoluteUri.length() - 1 : absoluteUri.length();
            String newJsonPointer = ((String)e.getKey()).substring(normalizedUriSize);
            String newUri = id.toString() + "#" + newJsonPointer;
            this.additionalSchemas.put(newUri, (Schema)e.getValue());
        });
        Schema identifiableSchema = new Schema(ctx.getParentUri(), id.toString(), validators);
        this.schemas.put(id.toString(), identifiableSchema);
        this.schemas.put(absoluteUri, identifiableSchema);
        this.registerAnchorsIfPresent(ctx, schemaNode, identifiableSchema);
    }

    private void registerAnchorsIfPresent(SchemaParsingContext ctx, JsonNode schemaNode, Schema schema) {
        JsonNode dynamicAnchorNode;
        if (!schemaNode.isObject()) {
            return;
        }
        Map<String, JsonNode> objectMap = schemaNode.asObject();
        JsonNode anchorNode = objectMap.get("$anchor");
        if (anchorNode != null && anchorNode.isString()) {
            String anchorFragment = "#" + anchorNode.asString();
            String anchoredUri = UriUtil.resolveUri(ctx.getParentUri(), anchorFragment);
            this.additionalSchemas.put(anchoredUri, schema);
        }
        if ((dynamicAnchorNode = objectMap.get("$dynamicAnchor")) != null && dynamicAnchorNode.isString()) {
            String anchorFragment = "#" + dynamicAnchorNode.asString();
            this.dynamicSchemas.put(ctx.getParentUri().toString() + anchorFragment, schema);
        }
    }
}

