/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Annotation;
import dev.harrel.jsonschema.AnnotationHeader;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;
import dev.harrel.jsonschema.ValidatorWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class Schema {
    private static final Validator TRUE_VALIDATOR = (ctx, node) -> ValidationResult.success();
    private static final Validator FALSE_VALIDATOR = (ctx, node) -> ValidationResult.failure("False schema always fails.");
    private final URI parentUri;
    private final String schemaLocation;
    private final List<ValidatorWrapper> validators;

    Schema(URI parentUri, String schemaLocation, List<ValidatorWrapper> validators) {
        this.parentUri = parentUri;
        this.schemaLocation = Objects.requireNonNull(schemaLocation);
        Objects.requireNonNull(validators);
        ArrayList<ValidatorWrapper> unsortedValidators = new ArrayList<ValidatorWrapper>(validators);
        Collections.sort(unsortedValidators);
        this.validators = Collections.unmodifiableList(unsortedValidators);
    }

    static Validator getBooleanValidator(boolean val) {
        return val ? TRUE_VALIDATOR : FALSE_VALIDATOR;
    }

    boolean validate(ValidationContext ctx, JsonNode node) {
        boolean outOfDynamicScope = ctx.isOutOfDynamicScope(this.parentUri);
        if (outOfDynamicScope) {
            ctx.pushDynamicScope(this.parentUri);
        }
        int annotationsBefore = ctx.getAnnotations().size();
        boolean valid = true;
        for (ValidatorWrapper validator : this.validators) {
            ValidationResult result = validator.validate(ctx, node);
            Annotation annotation = new Annotation(new AnnotationHeader(validator.getKeywordPath(), this.schemaLocation, node.getJsonPointer()), validator.getKeyword(), result.getErrorMessage(), result.isValid());
            ctx.addValidationAnnotation(annotation);
            ctx.addAnnotation(annotation);
            valid = valid && result.isValid();
        }
        if (!valid) {
            ctx.truncateAnnotationsToSize(annotationsBefore);
        }
        if (outOfDynamicScope) {
            ctx.popDynamicContext();
        }
        return valid;
    }
}

