/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class RequiredValidator
implements Validator {
    private final List<String> requiredProperties;

    RequiredValidator(JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.requiredProperties = node.asArray().stream().map(JsonNode::asString).toList();
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return ValidationResult.success();
        }
        Set<String> keys = node.asObject().keySet();
        if (keys.containsAll(this.requiredProperties)) {
            return ValidationResult.success();
        }
        HashSet<String> unsatisfied = new HashSet<String>(this.requiredProperties);
        unsatisfied.removeAll(keys);
        return ValidationResult.failure("Object does not have some of the required properties [%s]".formatted(unsatisfied));
    }
}

