/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.StringNode;
import dev.harrel.jsonschema.ValidationContext;

class PropertyNamesValidator
implements Applicator {
    private final String schemaRef;

    PropertyNamesValidator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getAbsoluteUri(node);
    }

    @Override
    public boolean apply(ValidationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return true;
        }
        Schema schema = ctx.resolveRequiredSchema(this.schemaRef);
        return node.asObject().keySet().stream().allMatch(propName -> schema.validate(ctx, new StringNode((String)propName, node.getJsonPointer())));
    }
}

