/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.ValidationContext;
import java.util.List;
import java.util.stream.IntStream;

class PrefixItemsValidator
implements Applicator {
    private final List<String> prefixRefs;

    PrefixItemsValidator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.prefixRefs = node.asArray().stream().map(ctx::getAbsoluteUri).toList();
    }

    @Override
    public boolean apply(ValidationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return true;
        }
        List<JsonNode> elements = node.asArray();
        return IntStream.range(0, elements.size()).limit(this.prefixRefs.size()).boxed().allMatch(idx -> ctx.resolveRequiredSchema(this.prefixRefs.get((int)idx)).validate(ctx, (JsonNode)elements.get((int)idx)));
    }
}

