/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;
import java.util.regex.Pattern;

class PatternValidator
implements Validator {
    private final Pattern pattern;

    PatternValidator(JsonNode node) {
        if (!node.isString()) {
            throw new IllegalArgumentException();
        }
        this.pattern = Pattern.compile(node.asString());
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode node) {
        if (!node.isString()) {
            return ValidationResult.success();
        }
        if (this.pattern.matcher(node.asString()).find()) {
            return ValidationResult.success();
        }
        return ValidationResult.failure("\"%s\" does not match regular expression [%s]".formatted(node.asString(), this.pattern.toString()));
    }
}

