/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.ValidationContext;
import java.util.List;

class OneOfValidator
implements Applicator {
    private final List<String> refs;

    OneOfValidator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.refs = node.asArray().stream().map(ctx::getAbsoluteUri).toList();
    }

    @Override
    public boolean apply(ValidationContext ctx, JsonNode node) {
        return this.refs.stream().filter(uri -> ctx.resolveRequiredSchema((String)uri).validate(ctx, node)).count() == 1L;
    }
}

