/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.ValidationContext;

class NotValidator
implements Applicator {
    private final String schemaUri;

    NotValidator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaUri = ctx.getAbsoluteUri(node);
    }

    @Override
    public boolean apply(ValidationContext ctx, JsonNode node) {
        return !ctx.resolveRequiredSchema(this.schemaUri).validate(ctx, node);
    }
}

