/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;
import java.math.BigDecimal;

class MultipleOfValidator
implements Validator {
    private final BigDecimal factor;

    MultipleOfValidator(JsonNode node) {
        if (!node.isNumber()) {
            throw new IllegalArgumentException();
        }
        this.factor = node.asNumber();
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode node) {
        if (!node.isNumber()) {
            return ValidationResult.success();
        }
        if (node.asNumber().remainder(this.factor).doubleValue() == 0.0) {
            return ValidationResult.success();
        }
        return ValidationResult.failure("%s is not multiple of %s".formatted(node.asNumber(), this.factor));
    }
}

