/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;
import java.math.BigDecimal;

class MinimumValidator
implements Validator {
    private final BigDecimal min;

    MinimumValidator(JsonNode node) {
        if (!node.isNumber()) {
            throw new IllegalArgumentException();
        }
        this.min = node.asNumber();
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode node) {
        if (!node.isNumber()) {
            return ValidationResult.success();
        }
        if (node.asNumber().compareTo(this.min) >= 0) {
            return ValidationResult.success();
        }
        return ValidationResult.failure("%s is lesser than %s".formatted(node.asNumber(), this.min));
    }
}

