/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;

class MinPropertiesValidator
implements Validator {
    private final int min;

    MinPropertiesValidator(JsonNode node) {
        if (!node.isInteger()) {
            throw new IllegalArgumentException();
        }
        this.min = node.asInteger().intValueExact();
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return ValidationResult.success();
        }
        if (node.asObject().size() >= this.min) {
            return ValidationResult.success();
        }
        return ValidationResult.failure("Object has less than %d properties".formatted(this.min));
    }
}

