/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;

class MinLengthValidator
implements Validator {
    private final int minLength;

    MinLengthValidator(JsonNode node) {
        if (!node.isInteger()) {
            throw new IllegalArgumentException();
        }
        this.minLength = node.asInteger().intValueExact();
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode node) {
        if (!node.isString()) {
            return ValidationResult.success();
        }
        String string = node.asString();
        if (string.codePointCount(0, string.length()) >= this.minLength) {
            return ValidationResult.success();
        }
        return ValidationResult.failure("\"%s\" is shorter than %d characters".formatted(string, this.minLength));
    }
}

