/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;

class MinItemsValidator
implements Validator {
    private final int minItems;

    MinItemsValidator(JsonNode node) {
        if (!node.isInteger()) {
            throw new IllegalArgumentException();
        }
        this.minItems = node.asInteger().intValueExact();
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return ValidationResult.success();
        }
        if (node.asArray().size() >= this.minItems) {
            return ValidationResult.success();
        }
        return ValidationResult.failure("Array has less than %d items".formatted(this.minItems));
    }
}

