/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;
import java.math.BigDecimal;

class MaximumValidator
implements Validator {
    private final BigDecimal max;

    MaximumValidator(JsonNode node) {
        if (!node.isNumber()) {
            throw new IllegalArgumentException();
        }
        this.max = node.asNumber();
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode node) {
        if (!node.isNumber()) {
            return ValidationResult.success();
        }
        if (node.asNumber().compareTo(this.max) <= 0) {
            return ValidationResult.success();
        }
        return ValidationResult.failure("%s is greater than %s".formatted(node.asNumber(), this.max));
    }
}

