/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;

class MaxPropertiesValidator
implements Validator {
    private final int max;

    MaxPropertiesValidator(JsonNode node) {
        if (!node.isInteger()) {
            throw new IllegalArgumentException();
        }
        this.max = node.asInteger().intValueExact();
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return ValidationResult.success();
        }
        if (node.asObject().size() <= this.max) {
            return ValidationResult.success();
        }
        return ValidationResult.failure("Object has more than %d properties".formatted(this.max));
    }
}

