/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;

class MaxItemsValidator
implements Validator {
    private final int maxItems;

    MaxItemsValidator(JsonNode node) {
        if (!node.isInteger()) {
            throw new IllegalArgumentException();
        }
        this.maxItems = node.asInteger().intValueExact();
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return ValidationResult.success();
        }
        if (node.asArray().size() <= this.maxItems) {
            return ValidationResult.success();
        }
        return ValidationResult.failure("Array has more than %d items".formatted(this.maxItems));
    }
}

