/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;
import java.util.Optional;

class MaxContainsValidator
implements Validator {
    private final String containsPath;
    private final int max;

    MaxContainsValidator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isInteger()) {
            throw new IllegalArgumentException();
        }
        this.containsPath = Optional.ofNullable(ctx.getCurrentSchemaObject().get("contains")).map(ctx::getAbsoluteUri).orElse(null);
        this.max = node.asInteger().intValueExact();
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode node) {
        if (!node.isArray() || this.containsPath == null) {
            return ValidationResult.success();
        }
        long count = ctx.getAnnotations().stream().filter(a -> a.header().schemaLocation().equals(this.containsPath)).count();
        if (count <= (long)this.max) {
            return ValidationResult.success();
        }
        return ValidationResult.failure("Array contains more than %d matching items".formatted(this.max));
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

