/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.MetaSchemaValidator;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.Validator;
import dev.harrel.jsonschema.ValidatorFactory;
import dev.harrel.jsonschema.ValidatorWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

final class JsonParser {
    private final String defaultMetaSchemaUri;
    private final JsonNodeFactory jsonNodeFactory;
    private final ValidatorFactory validatorFactory;
    private final SchemaRegistry schemaRegistry;
    private final MetaSchemaValidator metaSchemaValidator;

    JsonParser(String defaultMetaSchemaUri, JsonNodeFactory jsonNodeFactory, ValidatorFactory validatorFactory, SchemaRegistry schemaRegistry, MetaSchemaValidator metaSchemaValidator) {
        this.defaultMetaSchemaUri = defaultMetaSchemaUri;
        this.jsonNodeFactory = jsonNodeFactory;
        this.validatorFactory = validatorFactory;
        this.schemaRegistry = schemaRegistry;
        this.metaSchemaValidator = metaSchemaValidator;
    }

    void parseRootSchema(String baseUri, String rawJson) {
        this.parseRootSchema(URI.create(baseUri), this.jsonNodeFactory.create(rawJson));
    }

    URI parseRootSchema(URI baseUri, JsonNode node) {
        if (node.isBoolean()) {
            this.metaSchemaValidator.validateMetaSchema(this, this.defaultMetaSchemaUri, baseUri.toString(), node);
            SchemaParsingContext ctx = new SchemaParsingContext(this.schemaRegistry, baseUri.toString());
            boolean schemaValue = node.asBoolean();
            this.schemaRegistry.registerIdentifiableSchema(ctx, baseUri, node, List.of(new ValidatorWrapper(String.valueOf(schemaValue), node, Schema.getBooleanValidator(schemaValue))));
            return baseUri;
        }
        Map<String, JsonNode> objectMap = node.asObject();
        String metaSchemaUri = Optional.ofNullable(objectMap.get("$schema")).filter(JsonNode::isString).map(JsonNode::asString).orElse(this.defaultMetaSchemaUri);
        JsonNode idNode = objectMap.get("$id");
        if (idNode != null && idNode.isString()) {
            String idString = idNode.asString();
            this.metaSchemaValidator.validateMetaSchema(this, metaSchemaUri, idString, node);
            if (!baseUri.toString().equals(idString)) {
                SchemaParsingContext ctx = new SchemaParsingContext(this.schemaRegistry, idString);
                List<ValidatorWrapper> validators = this.parseValidators(ctx, objectMap, node.getJsonPointer());
                this.schemaRegistry.registerIdentifiableSchema(ctx, URI.create(idString), node, validators);
            }
        } else {
            this.metaSchemaValidator.validateMetaSchema(this, metaSchemaUri, baseUri.toString(), node);
        }
        SchemaParsingContext ctx = new SchemaParsingContext(this.schemaRegistry, baseUri.toString());
        List<ValidatorWrapper> validators = this.parseValidators(ctx, objectMap, node.getJsonPointer());
        this.schemaRegistry.registerIdentifiableSchema(ctx, baseUri, node, validators);
        return Optional.ofNullable(objectMap.get("$id")).filter(JsonNode::isString).map(JsonNode::asString).map(URI::create).orElse(baseUri);
    }

    private void parseNode(SchemaParsingContext ctx, JsonNode node) {
        if (node.isBoolean()) {
            this.parseBoolean(ctx, node);
        } else if (node.isArray()) {
            this.parseArray(ctx, node);
        } else if (node.isObject()) {
            this.parseObject(ctx, node);
        }
    }

    private void parseBoolean(SchemaParsingContext ctx, JsonNode node) {
        boolean schemaValue = node.asBoolean();
        Validator booleanValidator = Schema.getBooleanValidator(schemaValue);
        this.schemaRegistry.registerSchema(ctx, node, List.of(new ValidatorWrapper(String.valueOf(schemaValue), node, booleanValidator)));
    }

    private void parseArray(SchemaParsingContext ctx, JsonNode node) {
        for (JsonNode element : node.asArray()) {
            this.parseNode(ctx, element);
        }
    }

    private void parseObject(SchemaParsingContext ctx, JsonNode node) {
        Map<String, JsonNode> objectMap = node.asObject();
        Optional<String> metaSchemaUri = Optional.ofNullable(objectMap.get("$schema")).filter(JsonNode::isString).map(JsonNode::asString);
        JsonNode idNode = objectMap.get("$id");
        if (idNode != null && idNode.isString()) {
            String idString = idNode.asString();
            metaSchemaUri.ifPresent(uri -> this.metaSchemaValidator.validateMetaSchema(this, (String)uri, idString, node));
            URI uri2 = ctx.getParentUri().resolve(idString);
            SchemaParsingContext newCtx = ctx.withParentUri(uri2);
            List<ValidatorWrapper> validators = this.parseValidators(newCtx, objectMap, node.getJsonPointer());
            this.schemaRegistry.registerIdentifiableSchema(newCtx, uri2, node, validators);
        } else {
            metaSchemaUri.ifPresent(uri -> this.metaSchemaValidator.validateMetaSchema(this, (String)uri, ctx.getAbsoluteUri(node), node));
            this.schemaRegistry.registerSchema(ctx, node, this.parseValidators(ctx, objectMap, node.getJsonPointer()));
        }
    }

    private List<ValidatorWrapper> parseValidators(SchemaParsingContext ctx, Map<String, JsonNode> object, String objectPath) {
        SchemaParsingContext newCtx = ctx.withCurrentSchemaContext(object);
        ArrayList<ValidatorWrapper> validators = new ArrayList<ValidatorWrapper>();
        for (Map.Entry<String, JsonNode> entry : object.entrySet()) {
            this.validatorFactory.create(newCtx, entry.getKey(), entry.getValue()).map(validator -> new ValidatorWrapper((String)entry.getKey(), (JsonNode)entry.getValue(), (Validator)validator)).ifPresent(validators::add);
            this.parseNode(newCtx, entry.getValue());
        }
        if (validators.isEmpty()) {
            validators.add(new ValidatorWrapper("true", objectPath, Schema.getBooleanValidator(true)));
        }
        return validators;
    }
}

