/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.ValidationContext;
import java.util.List;
import java.util.Optional;

class ItemsValidator
implements Applicator {
    private final String schemaRef;
    private final int prefixItemsSize;

    ItemsValidator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getAbsoluteUri(node);
        this.prefixItemsSize = Optional.ofNullable(ctx.getCurrentSchemaObject().get("prefixItems")).map(JsonNode::asArray).map(List::size).orElse(0);
    }

    @Override
    public boolean apply(ValidationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return true;
        }
        Schema schema = ctx.resolveRequiredSchema(this.schemaRef);
        return node.asArray().stream().skip(this.prefixItemsSize).allMatch(element -> schema.validate(ctx, (JsonNode)element));
    }
}

