/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;
import java.util.Collections;
import java.util.List;

class EnumValidator
implements Validator {
    private final List<JsonNode> enumNodes;

    EnumValidator(JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.enumNodes = Collections.unmodifiableList(node.asArray());
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode node) {
        if (this.enumNodes.stream().anyMatch(node::isEqualTo)) {
            return ValidationResult.success();
        }
        return ValidationResult.failure("Expected any of [%s]".formatted(this.enumNodes.stream().map(JsonNode::toPrintableString).toList()));
    }
}

