/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.ValidationContext;
import dev.harrel.jsonschema.ValidationResult;
import dev.harrel.jsonschema.Validator;
import java.util.Optional;

class DynamicRefValidator
implements Validator {
    private final String ref;

    DynamicRefValidator(JsonNode node) {
        if (!node.isString()) {
            throw new IllegalArgumentException();
        }
        this.ref = node.asString();
    }

    @Override
    public ValidationResult validate(ValidationContext ctx, JsonNode node) {
        Optional<Schema> schema = ctx.resolveDynamicSchema(this.ref);
        if (schema.isEmpty()) {
            return ValidationResult.failure("Resolution of $ref [%s] failed".formatted(this.ref));
        }
        return schema.get().validate(ctx, node) ? ValidationResult.success() : ValidationResult.failure();
    }
}

