/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.ValidationContext;
import java.util.Map;
import java.util.stream.Collectors;

class DependentSchemasValidator
implements Applicator {
    private final Map<String, String> dependentSchemas;

    DependentSchemasValidator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject()) {
            throw new IllegalArgumentException();
        }
        this.dependentSchemas = node.asObject().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ctx.getAbsoluteUri((JsonNode)e.getValue())));
    }

    @Override
    public boolean apply(ValidationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return true;
        }
        return node.asObject().keySet().stream().filter(this.dependentSchemas::containsKey).map(this.dependentSchemas::get).map(ctx::resolveRequiredSchema).allMatch(schema -> schema.validate(ctx, node));
    }
}

