/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.AdditionalPropertiesValidator;
import dev.harrel.jsonschema.AllOfValidator;
import dev.harrel.jsonschema.AnyOfValidator;
import dev.harrel.jsonschema.ConstValidator;
import dev.harrel.jsonschema.ContainsValidator;
import dev.harrel.jsonschema.DependentRequiredValidator;
import dev.harrel.jsonschema.DependentSchemasValidator;
import dev.harrel.jsonschema.DynamicRefValidator;
import dev.harrel.jsonschema.EnumValidator;
import dev.harrel.jsonschema.ExclusiveMaximumValidator;
import dev.harrel.jsonschema.ExclusiveMinimumValidator;
import dev.harrel.jsonschema.IfThenElseValidator;
import dev.harrel.jsonschema.ItemsValidator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.MaxContainsValidator;
import dev.harrel.jsonschema.MaxItemsValidator;
import dev.harrel.jsonschema.MaxLengthValidator;
import dev.harrel.jsonschema.MaxPropertiesValidator;
import dev.harrel.jsonschema.MaximumValidator;
import dev.harrel.jsonschema.MinContainsValidator;
import dev.harrel.jsonschema.MinItemsValidator;
import dev.harrel.jsonschema.MinLengthValidator;
import dev.harrel.jsonschema.MinPropertiesValidator;
import dev.harrel.jsonschema.MinimumValidator;
import dev.harrel.jsonschema.MultipleOfValidator;
import dev.harrel.jsonschema.NotValidator;
import dev.harrel.jsonschema.OneOfValidator;
import dev.harrel.jsonschema.PatternPropertiesValidator;
import dev.harrel.jsonschema.PatternValidator;
import dev.harrel.jsonschema.PrefixItemsValidator;
import dev.harrel.jsonschema.PropertiesValidator;
import dev.harrel.jsonschema.PropertyNamesValidator;
import dev.harrel.jsonschema.RefValidator;
import dev.harrel.jsonschema.RequiredValidator;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.TypeValidator;
import dev.harrel.jsonschema.UnevaluatedItemsValidator;
import dev.harrel.jsonschema.UnevaluatedPropertiesValidator;
import dev.harrel.jsonschema.UniqueItemsValidator;
import dev.harrel.jsonschema.Validator;
import dev.harrel.jsonschema.ValidatorFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;

public class CoreValidatorFactory
implements ValidatorFactory {
    private final Map<String, BiFunction<SchemaParsingContext, JsonNode, Validator>> validatorsMap;

    public CoreValidatorFactory() {
        HashMap<String, BiFunction<SchemaParsingContext, JsonNode, Validator>> map = new HashMap<String, BiFunction<SchemaParsingContext, JsonNode, Validator>>();
        map.put("type", (ctx, node) -> new TypeValidator((JsonNode)node));
        map.put("const", (ctx, node) -> new ConstValidator((JsonNode)node));
        map.put("enum", (ctx, node) -> new EnumValidator((JsonNode)node));
        map.put("multipleOf", (ctx, node) -> new MultipleOfValidator((JsonNode)node));
        map.put("maximum", (ctx, node) -> new MaximumValidator((JsonNode)node));
        map.put("exclusiveMaximum", (ctx, node) -> new ExclusiveMaximumValidator((JsonNode)node));
        map.put("minimum", (ctx, node) -> new MinimumValidator((JsonNode)node));
        map.put("exclusiveMinimum", (ctx, node) -> new ExclusiveMinimumValidator((JsonNode)node));
        map.put("maxLength", (ctx, node) -> new MaxLengthValidator((JsonNode)node));
        map.put("minLength", (ctx, node) -> new MinLengthValidator((JsonNode)node));
        map.put("pattern", (ctx, node) -> new PatternValidator((JsonNode)node));
        map.put("maxItems", (ctx, node) -> new MaxItemsValidator((JsonNode)node));
        map.put("minItems", (ctx, node) -> new MinItemsValidator((JsonNode)node));
        map.put("uniqueItems", (ctx, node) -> new UniqueItemsValidator((JsonNode)node));
        map.put("maxContains", MaxContainsValidator::new);
        map.put("minContains", MinContainsValidator::new);
        map.put("maxProperties", (ctx, node) -> new MaxPropertiesValidator((JsonNode)node));
        map.put("minProperties", (ctx, node) -> new MinPropertiesValidator((JsonNode)node));
        map.put("required", (ctx, node) -> new RequiredValidator((JsonNode)node));
        map.put("dependentRequired", (ctx, node) -> new DependentRequiredValidator((JsonNode)node));
        map.put("prefixItems", PrefixItemsValidator::new);
        map.put("items", ItemsValidator::new);
        map.put("contains", ContainsValidator::new);
        map.put("additionalProperties", AdditionalPropertiesValidator::new);
        map.put("properties", PropertiesValidator::new);
        map.put("patternProperties", PatternPropertiesValidator::new);
        map.put("dependentSchemas", DependentSchemasValidator::new);
        map.put("propertyNames", PropertyNamesValidator::new);
        map.put("if", IfThenElseValidator::new);
        map.put("allOf", AllOfValidator::new);
        map.put("anyOf", AnyOfValidator::new);
        map.put("oneOf", OneOfValidator::new);
        map.put("not", NotValidator::new);
        map.put("unevaluatedItems", UnevaluatedItemsValidator::new);
        map.put("unevaluatedProperties", UnevaluatedPropertiesValidator::new);
        map.put("$ref", (ctx, node) -> new RefValidator((JsonNode)node));
        map.put("$dynamicRef", (ctx, node) -> new DynamicRefValidator((JsonNode)node));
        this.validatorsMap = Collections.unmodifiableMap(map);
    }

    @Override
    public Optional<Validator> create(SchemaParsingContext ctx, String fieldName, JsonNode node) {
        try {
            return Optional.ofNullable(this.validatorsMap.get(fieldName)).map(fun -> (Validator)fun.apply(ctx, node));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

