/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.ValidationContext;
import java.math.BigInteger;
import java.util.Optional;

class ContainsValidator
implements Applicator {
    private final String schemaRef;
    private final boolean minContainsZero;

    ContainsValidator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getAbsoluteUri(node);
        this.minContainsZero = Optional.ofNullable(ctx.getCurrentSchemaObject().get("minContains")).map(JsonNode::asInteger).map(BigInteger::intValueExact).map(min -> min == 0).orElse(false);
    }

    @Override
    public boolean apply(ValidationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return true;
        }
        Schema schema = ctx.resolveRequiredSchema(this.schemaRef);
        long count = node.asArray().stream().filter(element -> schema.validate(ctx, (JsonNode)element)).count();
        return count > 0L || this.minContainsZero;
    }
}

