/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Applicator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.ValidationContext;
import java.util.Set;
import java.util.stream.Collectors;

class AdditionalPropertiesValidator
implements Applicator {
    private final String schemaRef;
    private final String parentPath;

    AdditionalPropertiesValidator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        String schemaPointer = node.getJsonPointer();
        this.schemaRef = ctx.getAbsoluteUri(node);
        this.parentPath = schemaPointer.substring(0, schemaPointer.lastIndexOf(47));
    }

    @Override
    public boolean apply(ValidationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return true;
        }
        String instanceLocation = node.getJsonPointer();
        String propertiesPath = this.parentPath + "/properties";
        String patternPropertiesPath = this.parentPath + "/patternProperties";
        Set evaluatedInstances = ctx.getAnnotations().stream().filter(a -> a.header().instanceLocation().startsWith(instanceLocation)).filter(a -> a.header().evaluationPath().startsWith(propertiesPath) || a.header().evaluationPath().startsWith(patternPropertiesPath)).map(a -> a.header().instanceLocation()).collect(Collectors.toSet());
        Schema schema = ctx.resolveRequiredSchema(this.schemaRef);
        return node.asObject().values().stream().filter(prop -> !evaluatedInstances.contains(prop.getJsonPointer())).allMatch(prop -> schema.validate(ctx, (JsonNode)prop));
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

