/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.site.githubpages.internal;

import dev.gradleplugins.documentationkit.publish.githubpages.tasks.PublishToGitHubPages;
import dev.gradleplugins.documentationkit.site.base.internal.SiteBasePlugin;
import dev.gradleplugins.documentationkit.site.githubpages.GitHubPagesCustomDomain;
import dev.gradleplugins.documentationkit.site.githubpages.GitHubPagesSite;
import dev.gradleplugins.documentationkit.site.githubpages.tasks.GenerateGitHubPagesCustomDomainCanonicalNameRecord;
import dev.gradleplugins.documentationkit.site.githubpages.tasks.GenerateGitHubPagesNoJekyll;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;

public class GitHubPagesSitePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(SiteBasePlugin.class);
        GitHubPagesSite extension = (GitHubPagesSite)project.getExtensions().create("site", GitHubPagesSite.class, new Object[0]);
        extension.getHost().value(extension.getCustomDomain().map(GitHubPagesCustomDomain::get)).disallowChanges();
        extension.getDestinationDirectory().fileProvider(project.getTasks().named("stageSite", Sync.class).map(Sync::getDestinationDir)).disallowChanges();
        TaskProvider customDomainTask = project.getTasks().register("generateCustomDomainAlias", GenerateGitHubPagesCustomDomainCanonicalNameRecord.class, task -> {
            task.getOutputFile().value(project.getLayout().getBuildDirectory().file("CNAME")).disallowChanges();
            task.getCustomDomain().convention(extension.getCustomDomain());
        });
        TaskProvider noJekyllTask = project.getTasks().register("generateNoJekyll", GenerateGitHubPagesNoJekyll.class);
        TaskProvider stageSiteTask = project.getTasks().named("stageSite", Sync.class, task -> {
            task.from(new Object[]{customDomainTask.map(GenerateGitHubPagesCustomDomainCanonicalNameRecord::getOutputFile)});
            task.from(new Object[]{noJekyllTask.map(GenerateGitHubPagesNoJekyll::getOutputFile)});
        });
        project.getPluginManager().apply("dev.gradleplugins.documentation.github-pages-publish");
        project.getTasks().named("publishToGitHubPages", PublishToGitHubPages.class, task -> {
            task.getUri().convention(extension.getRepositorySlug().map(it -> project.uri((Object)("https://github.com/" + it + ".git"))));
            task.getPublishDirectory().fileProvider(stageSiteTask.map(Sync::getDestinationDir));
        });
    }
}

