/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.site.base;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.Serializable;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;

@JacksonXmlRootElement(localName="urlset")
public final class Sitemap {
    @JacksonXmlProperty(isAttribute=true)
    private final String xmlns = "https://www.sitemaps.org/schemas/sitemap/0.9";
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="url")
    private final Collection<Url> urls;

    public Sitemap(Collection<Url> urls) {
        this.urls = urls;
    }

    public Collection<Url> getUrls() {
        return this.urls;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sitemap)) {
            return false;
        }
        Sitemap other = (Sitemap)o;
        String this$xmlns = this.getXmlns();
        String other$xmlns = other.getXmlns();
        if (this$xmlns == null ? other$xmlns != null : !this$xmlns.equals(other$xmlns)) {
            return false;
        }
        Collection<Url> this$urls = this.getUrls();
        Collection<Url> other$urls = other.getUrls();
        return !(this$urls == null ? other$urls != null : !((Object)this$urls).equals(other$urls));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $xmlns = this.getXmlns();
        result = result * 59 + ($xmlns == null ? 43 : $xmlns.hashCode());
        Collection<Url> $urls = this.getUrls();
        result = result * 59 + ($urls == null ? 43 : ((Object)$urls).hashCode());
        return result;
    }

    public String toString() {
        return "Sitemap(xmlns=" + this.getXmlns() + ", urls=" + this.getUrls() + ")";
    }

    private String getXmlns() {
        return this.xmlns;
    }

    public static final class Url
    implements Serializable {
        @JacksonXmlProperty(localName="loc")
        private final URL location;
        @JacksonXmlProperty(localName="lastmod")
        private final LocalDate lastModified;

        public Url(URL location, LocalDate lastModified) {
            this.location = location;
            this.lastModified = lastModified;
        }

        public URL getLocation() {
            return this.location;
        }

        public LocalDate getLastModified() {
            return this.lastModified;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Url)) {
                return false;
            }
            Url other = (Url)o;
            URL this$location = this.getLocation();
            URL other$location = other.getLocation();
            if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
                return false;
            }
            LocalDate this$lastModified = this.getLastModified();
            LocalDate other$lastModified = other.getLastModified();
            return !(this$lastModified == null ? other$lastModified != null : !((Object)this$lastModified).equals(other$lastModified));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URL $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
            LocalDate $lastModified = this.getLastModified();
            result = result * 59 + ($lastModified == null ? 43 : ((Object)$lastModified).hashCode());
            return result;
        }

        public String toString() {
            return "Sitemap.Url(location=" + this.getLocation() + ", lastModified=" + this.getLastModified() + ")";
        }
    }
}

