/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.rendering.jbake.tasks.internal;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.MapProperty;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.jbake.app.Oven;
import org.jbake.app.configuration.ConfigUtil;
import org.jbake.app.configuration.DefaultJBakeConfiguration;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.app.configuration.JBakeConfigurationFactory;

public abstract class JBakeWorkAction
implements WorkAction<Parameters> {
    private static final Logger LOGGER = Logging.getLogger(JBakeWorkAction.class);

    public void execute() {
        Oven jbake = new Oven(JBakeWorkAction.jbakeConfiguration((Parameters)this.getParameters()));
        jbake.bake();
        List errors = jbake.getErrors();
        if (!errors.isEmpty()) {
            errors.forEach(it -> LOGGER.error(it.getMessage()));
            throw new IllegalStateException((Throwable)new MultipleBuildFailures((Collection)errors));
        }
    }

    private static JBakeConfiguration jbakeConfiguration(Parameters parameters) {
        JBakeConfigurationFactory factory = new JBakeConfigurationFactory();
        return factory.createDefaultJbakeConfiguration(JBakeWorkAction.sourceDirectory(parameters), JBakeWorkAction.destinationDirectory(parameters), JBakeWorkAction.configuration(parameters), false);
    }

    private static File sourceDirectory(Parameters parameters) {
        return ((Directory)parameters.getSourceDirectory().get()).getAsFile();
    }

    private static File destinationDirectory(Parameters parameters) {
        return ((Directory)parameters.getDestinationDirectory().get()).getAsFile();
    }

    private static CompositeConfiguration configuration(Parameters parameters) {
        CompositeConfiguration result = new CompositeConfiguration();
        result.addConfiguration((Configuration)new MapConfiguration(new HashMap((Map)parameters.getConfigurations().get())));
        result.addConfiguration(JBakeWorkAction.defaultConfiguration(parameters));
        return result;
    }

    private static Configuration defaultConfiguration(Parameters parameters) {
        return ((DefaultJBakeConfiguration)new ConfigUtil().loadConfig(((Directory)parameters.getSourceDirectory().get()).getAsFile())).getCompositeConfiguration();
    }

    public static interface Parameters
    extends WorkParameters {
        public DirectoryProperty getSourceDirectory();

        public DirectoryProperty getDestinationDirectory();

        public MapProperty<String, Object> getConfigurations();
    }
}

