/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.rendering.jbake.tasks;

import dev.gradleplugins.documentationkit.rendering.jbake.tasks.internal.JBakeWorkAction;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkerExecutor;

public abstract class RenderJBake
extends DefaultTask {
    private final WorkerExecutor workers;

    @InputDirectory
    public abstract DirectoryProperty getSourceDirectory();

    @Input
    public abstract MapProperty<String, Object> getConfigurations();

    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @OutputDirectory
    public abstract DirectoryProperty getDestinationDirectory();

    @Inject
    public RenderJBake(WorkerExecutor workers) {
        this.workers = workers;
    }

    @TaskAction
    private void doRender() throws IOException {
        FileUtils.cleanDirectory((File)((Directory)this.getDestinationDirectory().get()).getAsFile());
        this.workers.processIsolation(this::configureClasspath).submit(JBakeWorkAction.class, this::configureAction);
    }

    private void configureClasspath(ProcessWorkerSpec spec) {
        spec.getClasspath().from(new Object[]{this.getClasspath()});
    }

    private void configureAction(JBakeWorkAction.Parameters parameters) {
        parameters.getSourceDirectory().set((Provider)this.getSourceDirectory());
        parameters.getDestinationDirectory().set((Provider)this.getDestinationDirectory());
        parameters.getConfigurations().set(this.getConfigurations());
    }
}

