/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.rendering.jbake.tasks;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateRedirection
extends DefaultTask {
    @Nested
    public abstract SetProperty<Redirection> getRedirections();

    @OutputDirectory
    public abstract DirectoryProperty getDestinationDirectory();

    @TaskAction
    private void doGenerate() throws IOException {
        FileUtils.deleteDirectory((File)((Directory)this.getDestinationDirectory().get()).getAsFile());
        Directory dir = (Directory)this.getDestinationDirectory().get();
        for (Redirection redirection : (Set)this.getRedirections().get()) {
            File file = dir.file("content/" + redirection.getFrom() + "/index.adoc").getAsFile();
            file.getParentFile().mkdirs();
            PrintWriter out = new PrintWriter(file);
            Throwable throwable = null;
            try {
                Path from = dir.file(redirection.getFrom()).getAsFile().toPath();
                Path to = dir.file(redirection.getTo()).getAsFile().toPath();
                out.println(":jbake-type: redirection");
                out.println(":jbake-redirecturl: " + from.relativize(to).toString());
                out.println(":jbake-status: published");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
        dir.dir("templates").getAsFile().mkdirs();
        try (PrintWriter out = new PrintWriter(dir.file("templates/redirection.gsp").getAsFile());){
            out.println("<!DOCTYPE html>");
            out.println("<html lang=\"en\">");
            out.println("  <head>");
            out.println("\t<meta http-equiv=\"Refresh\" content=\"0; url=${content.redirecturl}\" />");
            out.println("\t<% include 'fragment-header-generic.gsp' %>");
            out.println("  </head>");
            out.println("  <body>");
            out.println("\t<p>Please follow <a href=\"${content.redirecturl}\">this link</a>.</p>");
            out.println("  </body>");
            out.println("</html>");
        }
    }

    public GenerateRedirection redirect(String from, String to) {
        this.getRedirections().add((Object)new Redirection(from, to));
        return this;
    }

    public static final class Redirection {
        @Input
        private final String from;
        @Input
        private final String to;

        public Redirection(String from, String to) {
            this.from = from;
            this.to = to;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Redirection)) {
                return false;
            }
            Redirection other = (Redirection)o;
            String this$from = this.getFrom();
            String other$from = other.getFrom();
            if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
                return false;
            }
            String this$to = this.getTo();
            String other$to = other.getTo();
            return !(this$to == null ? other$to != null : !this$to.equals(other$to));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : $from.hashCode());
            String $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : $to.hashCode());
            return result;
        }

        public String toString() {
            return "GenerateRedirection.Redirection(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
        }
    }
}

