/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.rendering.jbake.internal;

import com.google.common.collect.ImmutableMap;
import dev.gradleplugins.documentationkit.rendering.jbake.JBakeExtension;
import dev.gradleplugins.documentationkit.rendering.jbake.tasks.GenerateJBakeProperties;
import dev.gradleplugins.documentationkit.rendering.jbake.tasks.GenerateRedirection;
import dev.gradleplugins.documentationkit.rendering.jbake.tasks.RenderJBake;
import dev.nokee.platform.base.internal.dependencies.ProjectConfigurationActions;
import dev.nokee.platform.base.internal.dependencies.ProjectConfigurationRegistry;
import dev.nokee.utils.ActionUtils;
import dev.nokee.utils.TransformerUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.artifacts.transform.UnzipTransform;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class JBakeRenderPlugin
implements Plugin<Project> {
    public static final String ASSETS_CONFIGURATION_NAME = "assets";
    public static final String TEMPLATES_CONFIGURATION_NAME = "templates";
    public static final String CONTENT_CONFIGURATION_NAME = "content";
    public static final String CONFIGURATION_CONFIGURATION_NAME = "configuration";
    public static final String ASSETS_ELEMENTS_CONFIGURATION_NAME = "assetsElements";
    public static final String TEMPLATES_ELEMENTS_CONFIGURATION_NAME = "templatesElements";
    public static final String CONTENT_ELEMENTS_CONFIGURATION_NAME = "contentElements";
    public static final String CONFIGURATION_ELEMENTS_CONFIGURATION_NAME = "configurationElements";
    public static final String BAKED_ELEMENTS_CONFIGURATION_NAME = "bakedElements";
    static final String JBAKE_ASSETS_USAGE_NAME = "jbake-assets";
    static final String JBAKE_TEMPLATES_USAGE_NAME = "jbake-templates";
    static final String JBAKE_CONTENT_USAGE_NAME = "jbake-content";
    static final String JBAKE_CONFIGURATION_USAGE_NAME = "jbake-properties";
    static final String JBAKE_BAKED_USAGE_NAME = "jbake-baked";
    private final TaskContainer tasks;
    private final ProjectLayout layout;
    private final ConfigurationContainer configurations;
    private final DependencyHandler dependencies;
    private final SoftwareComponentFactory softwareComponentFactory;
    private static final Attribute<String> ARTIFACT_FORMAT = Attribute.of((String)"artifactType", String.class);

    @Inject
    public JBakeRenderPlugin(TaskContainer tasks, ProjectLayout layout, ConfigurationContainer configurations, DependencyHandler dependencies, SoftwareComponentFactory softwareComponentFactory) {
        this.tasks = tasks;
        this.layout = layout;
        this.configurations = configurations;
        this.dependencies = dependencies;
        this.softwareComponentFactory = softwareComponentFactory;
    }

    public void apply(Project project) {
        ProjectConfigurationRegistry configurationRegistry = ProjectConfigurationRegistry.forProject((Project)project);
        JBakeExtension extension = (JBakeExtension)project.getExtensions().create("jbake", JBakeExtension.class, new Object[0]);
        extension.getAssets().from(new Object[]{"src/jbake/assets"});
        extension.getTemplates().from(new Object[]{"src/jbake/templates"});
        extension.getContent().from(new Object[]{"src/jbake/content"});
        extension.getConfigurations().putAll(project.provider(() -> JBakeRenderPlugin.loadPropertiesFileIfAvailable((FileSystemLocation)this.layout.getProjectDirectory().file("src/jbake/jbake.properties"))));
        TaskProvider redirectionTask = this.tasks.register("redirections", GenerateRedirection.class, task -> task.getDestinationDirectory().convention(this.layout.getBuildDirectory().dir("tmp/" + task.getName())));
        extension.getContent().from(new Object[]{redirectionTask.flatMap(it -> it.getDestinationDirectory().dir(CONTENT_CONFIGURATION_NAME))});
        extension.getTemplates().from(new Object[]{redirectionTask.flatMap(it -> it.getDestinationDirectory().dir(TEMPLATES_CONFIGURATION_NAME))});
        extension.getConfigurations().putAll(redirectionTask.map(it -> {
            HashMap result = new HashMap();
            ((Directory)it.getDestinationDirectory().dir(TEMPLATES_CONFIGURATION_NAME).get()).getAsFileTree().visit(details -> result.put("template." + FilenameUtils.removeExtension((String)details.getName()) + ".file", details.getName()));
            return result;
        }));
        TaskProvider bakePropertiesTask = this.tasks.register("bakeProperties", GenerateJBakeProperties.class, task -> {
            task.getConfigurations().value(extension.getConfigurations()).disallowChanges();
            task.getOutputFile().value(this.layout.getBuildDirectory().file("tmp/" + task.getName() + "/jbake.properties"));
        });
        Configuration jbake = configurationRegistry.createIfAbsent("jbake", (Action)ProjectConfigurationActions.asDeclarable());
        Configuration content = configurationRegistry.createIfAbsent(CONTENT_CONFIGURATION_NAME, (Action)ProjectConfigurationActions.asResolvable().andThen(JBakeRenderPlugin.attributes(JBAKE_CONTENT_USAGE_NAME)).andThen(ProjectConfigurationActions.forArtifactFormat((String)"directory")).andThen(ProjectConfigurationActions.extendsFrom((Configuration[])new Configuration[]{jbake})));
        Configuration templates = configurationRegistry.createIfAbsent(TEMPLATES_CONFIGURATION_NAME, (Action)ProjectConfigurationActions.asResolvable().andThen(JBakeRenderPlugin.attributes(JBAKE_TEMPLATES_USAGE_NAME)).andThen(ProjectConfigurationActions.forArtifactFormat((String)"directory")).andThen(ProjectConfigurationActions.extendsFrom((Configuration[])new Configuration[]{jbake})));
        Configuration assets = configurationRegistry.createIfAbsent(ASSETS_CONFIGURATION_NAME, (Action)ProjectConfigurationActions.asResolvable().andThen(JBakeRenderPlugin.attributes(JBAKE_ASSETS_USAGE_NAME)).andThen(ProjectConfigurationActions.forArtifactFormat((String)"directory")).andThen(ProjectConfigurationActions.extendsFrom((Configuration[])new Configuration[]{jbake})));
        Configuration configuration = configurationRegistry.createIfAbsent(CONFIGURATION_CONFIGURATION_NAME, (Action)ProjectConfigurationActions.asResolvable().andThen(JBakeRenderPlugin.attributes(JBAKE_CONFIGURATION_USAGE_NAME)).andThen(ProjectConfigurationActions.extendsFrom((Configuration[])new Configuration[]{jbake})));
        project.getDependencies().registerTransform(UnzipTransform.class, JBakeRenderPlugin.unzipArtifact(JBAKE_CONTENT_USAGE_NAME, project.getObjects()));
        project.getDependencies().registerTransform(UnzipTransform.class, JBakeRenderPlugin.unzipArtifact(JBAKE_ASSETS_USAGE_NAME, project.getObjects()));
        project.getDependencies().registerTransform(UnzipTransform.class, JBakeRenderPlugin.unzipArtifact(JBAKE_TEMPLATES_USAGE_NAME, project.getObjects()));
        project.getDependencies().registerTransform(UnzipTransform.class, JBakeRenderPlugin.unzipArtifact(JBAKE_BAKED_USAGE_NAME, project.getObjects()));
        Configuration contentElements = configurationRegistry.create(CONTENT_ELEMENTS_CONFIGURATION_NAME, (Action)ProjectConfigurationActions.asConsumable().andThen(JBakeRenderPlugin.attributes(JBAKE_CONTENT_USAGE_NAME)).andThen(ProjectConfigurationActions.artifactOf((FileCollection)extension.getContent())));
        Configuration templatesElements = configurationRegistry.create(TEMPLATES_ELEMENTS_CONFIGURATION_NAME, (Action)ProjectConfigurationActions.asConsumable().andThen(JBakeRenderPlugin.attributes(JBAKE_TEMPLATES_USAGE_NAME)).andThen(ProjectConfigurationActions.artifactOf((FileCollection)extension.getTemplates())));
        Configuration assetsElements = configurationRegistry.create(ASSETS_ELEMENTS_CONFIGURATION_NAME, (Action)ProjectConfigurationActions.asConsumable().andThen(JBakeRenderPlugin.attributes(JBAKE_ASSETS_USAGE_NAME)).andThen(ProjectConfigurationActions.artifactOf((FileCollection)extension.getAssets())));
        Configuration configurationElements = configurationRegistry.create(CONFIGURATION_ELEMENTS_CONFIGURATION_NAME, (Action)ProjectConfigurationActions.asConsumable().andThen(JBakeRenderPlugin.attributes(JBAKE_CONFIGURATION_USAGE_NAME)).andThen(ProjectConfigurationActions.using((ObjectFactory)project.getObjects(), (Action)ProjectConfigurationActions.artifactIfExists((Provider)bakePropertiesTask.flatMap(GenerateJBakeProperties::getOutputFile)))));
        Configuration bakedElements = configurationRegistry.create(BAKED_ELEMENTS_CONFIGURATION_NAME, (Action)ProjectConfigurationActions.asConsumable().andThen(JBakeRenderPlugin.attributes(JBAKE_BAKED_USAGE_NAME)).andThen(ProjectConfigurationActions.artifactOf((Provider)extension.getDestinationDirectory())));
        TaskProvider stageTask = project.getTasks().register("stageBake", Sync.class, task -> {
            task.into((Object)CONTENT_CONFIGURATION_NAME, spec -> spec.from(new Object[]{content}).from(new Object[]{extension.getContent()}));
            task.into((Object)ASSETS_CONFIGURATION_NAME, spec -> spec.from(new Object[]{assets}).from(new Object[]{extension.getAssets()}));
            task.into((Object)TEMPLATES_CONFIGURATION_NAME, spec -> spec.from(new Object[]{templates}).from(new Object[]{extension.getTemplates()}));
            task.setDestinationDir(((Directory)project.getLayout().getBuildDirectory().dir("tmp/" + task.getName()).get()).getAsFile());
            task.setIncludeEmptyDirs(false);
        });
        TaskProvider bakeTask = project.getTasks().register("bake", RenderJBake.class, task -> {
            task.setGroup("documentation");
            task.setDescription("Bakes with JBake");
            task.getSourceDirectory().fileProvider(stageTask.map(Sync::getDestinationDir));
            task.getDestinationDirectory().set(project.getLayout().getBuildDirectory().dir("jbake"));
            task.getConfigurations().putAll(configuration.getIncoming().getFiles().getElements().map((Transformer)TransformerUtils.transformEach(JBakeRenderPlugin::loadPropertiesFileIfAvailable).andThen(JBakeRenderPlugin::mergeConfigurations)));
            task.getConfigurations().put((Object)"working.directory", stageTask.map(this::relativeToProjectDirectory));
            task.getConfigurations().putAll(extension.getConfigurations());
            task.getClasspath().from(new Object[]{this.jbake("2.6.5")}).from(new Object[]{this.asciidoctor("2.2.0")}).from(new Object[]{this.groovyTemplates("3.0.2")}).from(new Object[]{this.flexmarkTemplates("0.61.0")}).from(new Object[]{this.freemarkerTemplates("2.3.30")}).from(new Object[]{this.pegdownTemplates("1.6.0")}).from(new Object[]{this.thymeleafTemplates("3.0.11.RELEASE")}).from(new Object[]{this.jade4jTemplates("1.2.7")}).from(new Object[]{this.pebbleTemplates("3.1.4")});
        });
        extension.getDestinationDirectory().value(bakeTask.flatMap(RenderJBake::getDestinationDirectory)).disallowChanges();
        AdhocComponentWithVariants jbakeComponent = this.softwareComponentFactory.adhoc("jbake");
        jbakeComponent.addVariantsFromConfiguration(contentElements, (Action)ProjectConfigurationActions.skipIf((Spec)ProjectConfigurationActions.hasUnpublishableArtifactType()));
        jbakeComponent.addVariantsFromConfiguration(templatesElements, (Action)ProjectConfigurationActions.skipIf((Spec)ProjectConfigurationActions.hasUnpublishableArtifactType()));
        jbakeComponent.addVariantsFromConfiguration(assetsElements, (Action)ProjectConfigurationActions.skipIf((Spec)ProjectConfigurationActions.hasUnpublishableArtifactType()));
        jbakeComponent.addVariantsFromConfiguration(configurationElements, (Action)ProjectConfigurationActions.skipIf((Spec)ProjectConfigurationActions.hasUnpublishableArtifactType()));
        jbakeComponent.addVariantsFromConfiguration(bakedElements, (Action)ProjectConfigurationActions.skipIf((Spec)ProjectConfigurationActions.hasUnpublishableArtifactType()));
        project.getComponents().add((Object)jbakeComponent);
    }

    private String relativeToProjectDirectory(Sync task) {
        return this.layout.getProjectDirectory().getAsFile().toPath().relativize(task.getDestinationDir().toPath()).toString();
    }

    private FileCollection jbake(String version) {
        return this.configurations.detachedConfiguration(new Dependency[]{this.dependencies.create((Object)("org.jbake:jbake-core:" + version))});
    }

    private FileCollection asciidoctor(String version) {
        return this.configurations.detachedConfiguration(new Dependency[]{this.dependencies.create((Object)("org.asciidoctor:asciidoctorj:" + version))});
    }

    private FileCollection groovyTemplates(String version) {
        return this.configurations.detachedConfiguration(new Dependency[]{this.dependencies.create((Object)("org.codehaus.groovy:groovy:" + version)), this.dependencies.create((Object)("org.codehaus.groovy:groovy-templates:" + version))});
    }

    private FileCollection flexmarkTemplates(String version) {
        return this.configurations.detachedConfiguration(new Dependency[]{this.dependencies.create((Object)("com.vladsch.flexmark:flexmark:" + version)), this.dependencies.create((Object)("com.vladsch.flexmark:flexmark-profile-pegdown:" + version))});
    }

    private FileCollection freemarkerTemplates(String version) {
        return this.configurations.detachedConfiguration(new Dependency[]{this.dependencies.create((Object)("org.freemarker:freemarker:" + version))});
    }

    private FileCollection pegdownTemplates(String version) {
        return this.configurations.detachedConfiguration(new Dependency[]{this.dependencies.create((Object)("org.pegdown:pegdown:" + version))});
    }

    private FileCollection thymeleafTemplates(String version) {
        return this.configurations.detachedConfiguration(new Dependency[]{this.dependencies.create((Object)("org.thymeleaf:thymeleaf:" + version))});
    }

    private FileCollection jade4jTemplates(String version) {
        return this.configurations.detachedConfiguration(new Dependency[]{this.dependencies.create((Object)("de.neuland-bfi:jade4j:" + version))});
    }

    private FileCollection pebbleTemplates(String version) {
        return this.configurations.detachedConfiguration(new Dependency[]{this.dependencies.create((Object)("io.pebbletemplates:pebble:" + version))});
    }

    private static Map<String, Object> loadPropertiesFileIfAvailable(FileSystemLocation propertiesFile) {
        if (!propertiesFile.getAsFile().exists()) {
            return ImmutableMap.of();
        }
        Properties properties = new Properties();
        try (FileInputStream inStream = new FileInputStream(propertiesFile.getAsFile());){
            properties.load(inStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> builder.put((Object)key.toString(), value)));
        return builder.build();
    }

    private static Map<String, Object> mergeConfigurations(Iterable<Map<String, Object>> configurations) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        configurations.forEach(arg_0 -> ((ImmutableMap.Builder)builder).putAll(arg_0));
        return builder.build();
    }

    private static ActionUtils.Action<Configuration> attributes(String usage) {
        return ProjectConfigurationActions.forUsage((String)usage).andThen(ProjectConfigurationActions.forDocsType((String)usage));
    }

    private static Action<TransformSpec<TransformParameters.None>> unzipArtifact(String targetUsage, ObjectFactory objects) {
        return variantTransform -> {
            variantTransform.getFrom().attribute(ARTIFACT_FORMAT, (Object)"zip");
            variantTransform.getFrom().attribute(DocsType.DOCS_TYPE_ATTRIBUTE, (Object)objects.named(DocsType.class, targetUsage));
            variantTransform.getTo().attribute(ARTIFACT_FORMAT, (Object)"directory");
            variantTransform.getTo().attribute(DocsType.DOCS_TYPE_ATTRIBUTE, (Object)objects.named(DocsType.class, targetUsage));
        };
    }
}

