/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.publish.githubpages.internal;

import dev.gradleplugins.documentationkit.publish.githubpages.internal.GitHubCredentialsFactory;
import dev.gradleplugins.documentationkit.publish.githubpages.internal.GitHubRepositoryUtils;
import dev.gradleplugins.documentationkit.publish.githubpages.tasks.PublishToGitHubPages;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.tasks.TaskProvider;

public class GitHubPagesPublishPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(PublishingPlugin.class);
        GitHubCredentialsFactory credentialsFactory = new GitHubCredentialsFactory(project.getProviders());
        TaskProvider publishTask = project.getTasks().register("publishToGitHubPages", PublishToGitHubPages.class, task -> {
            task.setGroup("publishing");
            task.setDescription("Publishes site produced by this project to GitHub pages.");
            task.getCredentials().convention((Object)credentialsFactory.fromEnvironmentVariable());
            task.getUri().convention(project.provider(() -> GitHubRepositoryUtils.inferGitHubHttpRepositoryUri(project.getRootDir())));
        });
        project.getTasks().named("publish", task -> task.dependsOn(new Object[]{publishTask}));
    }
}

