/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.grava.testing.util;

import java.time.Duration;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.function.FailableRunnable;

public final class RetryUtils {
    private RetryUtils() {
    }

    public static <E extends Throwable> int retry(FailableRunnable<E> closure) throws InterruptedException, E {
        return RetryUtils.retry(3, closure);
    }

    public static <E extends Throwable> int retry(int retries, FailableRunnable<E> closure) throws InterruptedException, E {
        return RetryUtils.retry(retries, Duration.ZERO, closure);
    }

    public static <E extends Throwable> int retry(int retries, Duration waitBetweenRetries, FailableRunnable<E> closure) throws InterruptedException, E {
        int retryCount = 0;
        Throwable lastException = null;
        while (retryCount++ < retries) {
            try {
                closure.run();
                return retryCount;
            }
            catch (Throwable e) {
                lastException = e;
                Thread.sleep(waitBetweenRetries.toMillis());
            }
        }
        return (Integer)ExceptionUtils.rethrow(lastException);
    }
}

