/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.grava.testing.util;

import dev.gradleplugins.grava.testing.file.TestNameTestDirectoryProvider;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.testfixtures.ProjectBuilder;

public final class ProjectTestUtils {
    private static final String CLEANUP_THREAD_NAME = "project-test-utils-cleanup";
    private static final AtomicBoolean SHUTDOWN_REGISTERED = new AtomicBoolean();
    private static final List<TestNameTestDirectoryProvider> PROJECT_DIRECTORIES_TO_CLEANUP = Collections.synchronizedList(new LinkedList());
    private static Project _use_project_method = null;

    private ProjectTestUtils() {
    }

    private static void maybeRegisterCleanup() {
        if (SHUTDOWN_REGISTERED.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        List list = PROJECT_DIRECTORIES_TO_CLEANUP;
                        synchronized (list) {
                            for (TestNameTestDirectoryProvider testDirectory : PROJECT_DIRECTORIES_TO_CLEANUP) {
                                testDirectory.cleanup();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, CLEANUP_THREAD_NAME));
        }
    }

    private static Project project() {
        if (_use_project_method == null) {
            _use_project_method = ProjectTestUtils.rootProject();
        }
        return _use_project_method;
    }

    public static ObjectFactory objectFactory() {
        return ProjectTestUtils.project().getObjects();
    }

    public static ProviderFactory providerFactory() {
        return ProjectTestUtils.project().getProviders();
    }

    public static Dependency createDependency(Object notation) {
        return ProjectTestUtils.project().getDependencies().create(notation);
    }

    public static Project rootProject() {
        ProjectTestUtils.maybeRegisterCleanup();
        TestNameTestDirectoryProvider testDirectory = new TestNameTestDirectoryProvider(ProjectTestUtils.class);
        PROJECT_DIRECTORIES_TO_CLEANUP.add(testDirectory);
        return ProjectBuilder.builder().withProjectDir(testDirectory.getTestDirectory().toFile()).build();
    }

    public static Project createRootProject(File rootDirectory) {
        return ProjectBuilder.builder().withProjectDir(rootDirectory).build();
    }

    public static Project createRootProject(Path rootDirectory) {
        return ProjectTestUtils.createRootProject(rootDirectory.toFile());
    }

    public static Project createChildProject(Project parent) {
        return ProjectTestUtils.createChildProject(parent, "test");
    }

    public static Project createChildProject(Project parent, String name) {
        return ProjectTestUtils.createChildProject(parent, name, new File(parent.getProjectDir(), name));
    }

    public static Project createChildProject(Project parent, String name, File projectDirectory) {
        return ProjectBuilder.builder().withName(name).withParent(parent).withProjectDir(ProjectTestUtils.toCanonicalFile(projectDirectory)).build();
    }

    public static Project createChildProject(Project parent, String name, Path projectDirectory) {
        return ProjectTestUtils.createChildProject(parent, name, projectDirectory.toFile());
    }

    public static Project evaluate(Project project) {
        return ((ProjectInternal)project).evaluate();
    }

    private static File toCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

