/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.grava.testing;

import dev.gradleplugins.fixtures.runnerkit.BuildResultMatchers;
import dev.gradleplugins.grava.testing.AbstractTester;
import dev.gradleplugins.grava.testing.TestCase;
import dev.gradleplugins.grava.testing.file.TestNameTestDirectoryProvider;
import dev.gradleplugins.runnerkit.BuildResult;
import dev.gradleplugins.runnerkit.GradleExecutor;
import dev.gradleplugins.runnerkit.GradleRunner;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.opentest4j.TestAbortedException;

public final class WellBehavedPluginTester
extends AbstractTester {
    private String qualifiedPluginId;
    private Class<? extends Plugin<?>> pluginType;
    private EnumSet<SupportedTarget> targets = null;
    private Boolean crossTargetErrorSupport = null;
    private static final boolean LEAVE_WORKSPACE_BEHIND_ON_ERRORS = Boolean.parseBoolean(System.getProperty("dev.gradleplugins.internal.leave-workspace-behind-on-errors", "false"));

    private String getQualifiedPluginIdUnderTest() {
        if (this.qualifiedPluginId == null) {
            throw new TestAbortedException();
        }
        return this.qualifiedPluginId;
    }

    private Class<? extends Plugin<?>> getPluginTypeUnderTest() {
        if (this.pluginType == null) {
            throw new TestAbortedException();
        }
        return this.pluginType;
    }

    public WellBehavedPluginTester qualifiedPluginId(String qualifiedPluginId) {
        this.qualifiedPluginId = qualifiedPluginId;
        return this;
    }

    public <T extends Plugin<?>> WellBehavedPluginTester pluginClass(Class<T> pluginType) {
        this.pluginType = pluginType;
        return this;
    }

    public WellBehavedPluginTester supportedTarget(SupportedTarget ... targets) {
        this.targets = EnumSet.copyOf(Arrays.asList(targets));
        return this;
    }

    public WellBehavedPluginTester doesNotWellBehaveWhenAppliedToUnsupportedTarget() {
        this.crossTargetErrorSupport = false;
        return this;
    }

    @Override
    protected void collectTesters(List<TestCase> testCases) {
        if (this.targets == null) {
            this.targets = EnumSet.of(SupportedTarget.Project);
            if (this.crossTargetErrorSupport == null) {
                this.crossTargetErrorSupport = false;
            }
        }
        if (this.crossTargetErrorSupport == null) {
            this.crossTargetErrorSupport = true;
        }
        for (SupportedTarget target : this.targets) {
            if (target != SupportedTarget.Init) {
                testCases.add(new AppliesPluginTypeWhenApplyingPluginId(target));
                testCases.add(new CanApplyPluginByIdUsingPluginAwareApply(target));
                testCases.add(new CanApplyPluginViaPluginDsl(target));
            }
            testCases.add(new CanApplyPluginByTypeUsingPluginAwareApply(target));
            testCases.add(new CanExecuteHelpTask(target));
            testCases.add(new CanExecuteTasksTask(target));
            testCases.add(new DoesNotRealizeTask(target));
            testCases.add(new DoesNotResolveConfiguration(target));
            testCases.add(new CanResolveAllDomainObjects(target));
        }
        if (this.crossTargetErrorSupport.booleanValue()) {
            for (SupportedTarget target : EnumSet.complementOf(this.targets)) {
                testCases.add(new ThrowsSensibleExceptionWhenApplyingPluginOnWrongTarget(target));
            }
        }
    }

    private String appliesPluginToTarget(SupportedTarget target) {
        if (target == SupportedTarget.Init || this.qualifiedPluginId == null) {
            return "apply plugin: Class.forName('" + this.getPluginTypeUnderTest().getTypeName() + "')";
        }
        return "apply plugin: '" + this.getQualifiedPluginIdUnderTest() + "'";
    }

    public void testWellBehavedPlugin() {
        if (this.qualifiedPluginId == null && this.pluginType == null) {
            throw new AssertionError((Object)"Missing qualified plugin id and/or plugin type");
        }
        this.executeAllTestCases();
    }

    private class CanResolveAllDomainObjects
    extends AbstractWellBehavedIntegrationTest {
        private final SupportedTarget target;

        private CanResolveAllDomainObjects(SupportedTarget target) {
            this.target = target;
        }

        @Override
        public String getDisplayName() {
            return "can resolve all domain objects [" + (Object)((Object)this.target) + "]";
        }

        @Override
        public void doExecute() throws Throwable {
            this.buildScript(this.target.getBuildScriptName()).append(WellBehavedPluginTester.this.appliesPluginToTarget(this.target));
            this.getBuildFile().append("allprojects {", "  tasks.all { /* TaskContainer#all force all object to realize */ }", "  configurations.all { /* ConfigurationContainer#all force all object to realize */ }", "}");
            this.succeeds(new String[0]);
        }
    }

    private class DoesNotResolveConfiguration
    extends AbstractWellBehavedIntegrationTest {
        private final SupportedTarget target;

        private DoesNotResolveConfiguration(SupportedTarget target) {
            this.target = target;
        }

        @Override
        public String getDisplayName() {
            return "does not resolve configuration [" + (Object)((Object)this.target) + "]";
        }

        @Override
        public void doExecute() throws Throwable {
            this.buildScript(this.target.getBuildScriptName()).append(WellBehavedPluginTester.this.appliesPluginToTarget(this.target));
            this.getBuildFile().append("def resolvedDependenciesPaths = []", "allprojects {", "  configurations.all { configuration ->", "    // In case the configuration was already resolved...", "    if (configuration.state == Configuration.State.RESOLVED) {", "      resolvedDependenciesPaths << incoming.path", "    } else {", "      configuration.incoming.afterResolve { resolvedDep ->", "        resolvedDependenciesPaths << resolvedDep.path", "      }", "    }", "  }", "}", "", "gradle.buildFinished {", "    assert resolvedDependenciesPaths == [] : 'some configuration were resolved'", "}");
            this.succeeds(new String[0]);
        }
    }

    private class DoesNotRealizeTask
    extends AbstractWellBehavedIntegrationTest {
        private final SupportedTarget target;

        private DoesNotRealizeTask(SupportedTarget target) {
            this.target = target;
        }

        @Override
        public String getDisplayName() {
            return "does not realize task [" + (Object)((Object)this.target) + "]";
        }

        protected List<String> getRealizedTaskPaths() {
            return Collections.singletonList(":help");
        }

        private List<String> getRealizedQuotedTaskPaths() {
            return this.getRealizedTaskPaths().stream().map(this::quoted).collect(Collectors.toList());
        }

        private String quoted(String s) {
            return "'" + s + "'";
        }

        @Override
        public void doExecute() throws Throwable {
            this.buildScript(this.target.getBuildScriptName()).append(WellBehavedPluginTester.this.appliesPluginToTarget(this.target));
            this.getBuildFile().append("def configuredTasks = []", "allprojects {", "  tasks.configureEach {", "    configuredTasks << it", "  }", "}", "", "gradle.buildFinished {", "  def configuredTaskPaths = configuredTasks*.path", "", "  // TODO: Log warning if getRealizedTaskPaths() is different than ':help'", "  configuredTaskPaths.removeAll([" + String.join((CharSequence)", ", this.getRealizedQuotedTaskPaths()) + "])", "  assert configuredTaskPaths == []", "}");
            this.succeeds("help");
        }
    }

    private class CanExecuteTasksTask
    extends AbstractWellBehavedIntegrationTest {
        private final SupportedTarget target;

        private CanExecuteTasksTask(SupportedTarget target) {
            this.target = target;
        }

        @Override
        public String getDisplayName() {
            return "can execute tasks task [" + (Object)((Object)this.target) + "]";
        }

        @Override
        public void doExecute() throws Throwable {
            this.buildScript(this.target.getBuildScriptName()).append(WellBehavedPluginTester.this.appliesPluginToTarget(this.target));
            this.succeeds("tasks");
        }
    }

    private class CanExecuteHelpTask
    extends AbstractWellBehavedIntegrationTest {
        private final SupportedTarget target;

        private CanExecuteHelpTask(SupportedTarget target) {
            this.target = target;
        }

        @Override
        public String getDisplayName() {
            return "can execute help task [" + (Object)((Object)this.target) + "]";
        }

        @Override
        public void doExecute() throws Throwable {
            this.buildScript(this.target.getBuildScriptName()).append(WellBehavedPluginTester.this.appliesPluginToTarget(this.target));
            this.succeeds("help");
        }
    }

    private final class ThrowsSensibleExceptionWhenApplyingPluginOnWrongTarget
    extends AbstractWellBehavedIntegrationTest {
        private final SupportedTarget target;

        ThrowsSensibleExceptionWhenApplyingPluginOnWrongTarget(SupportedTarget target) {
            this.target = target;
        }

        @Override
        public String getDisplayName() {
            return "throws exception when applying plugin on wrong target, e.g. " + (Object)((Object)this.target);
        }

        @Override
        public void doExecute() throws Throwable {
            this.buildScript(this.target.getBuildScriptName()).append(WellBehavedPluginTester.this.appliesPluginToTarget(this.target));
            BuildResult result = this.fails(new String[0]);
            MatcherAssert.assertThat((String)"gives sensible exception when applying to wrong target", (Object)result, (Matcher)Matchers.not((Matcher)BuildResultMatchers.hasFailureCause((Matcher)Matchers.containsString((String)"_Decorated cannot be cast to org.gradle.api"))));
        }
    }

    private final class CanApplyPluginViaPluginDsl
    extends AbstractWellBehavedIntegrationTest {
        private final SupportedTarget target;

        private CanApplyPluginViaPluginDsl(SupportedTarget target) {
            this.target = target;
        }

        @Override
        public String getDisplayName() {
            return "can apply plugin via plugin DSL [" + (Object)((Object)this.target) + "]";
        }

        @Override
        public void doExecute() throws Throwable {
            this.buildScript(this.target.getBuildScriptName()).append("plugins {", "  id '" + WellBehavedPluginTester.this.getQualifiedPluginIdUnderTest() + "'", "}");
            this.succeeds(new String[0]);
        }
    }

    private final class CanApplyPluginByTypeUsingPluginAwareApply
    extends AbstractWellBehavedIntegrationTest {
        private final SupportedTarget target;

        private CanApplyPluginByTypeUsingPluginAwareApply(SupportedTarget target) {
            this.target = target;
        }

        @Override
        public String getDisplayName() {
            return "can apply plugin by id using apply(plugin: <class>) [" + (Object)((Object)this.target) + "]";
        }

        @Override
        public void doExecute() throws Throwable {
            this.buildScript(this.target.getBuildScriptName()).append("apply plugin: Class.forName('" + WellBehavedPluginTester.this.getPluginTypeUnderTest().getTypeName() + "')");
            this.succeeds(new String[0]);
        }
    }

    private final class CanApplyPluginByIdUsingPluginAwareApply
    extends AbstractWellBehavedIntegrationTest {
        private final SupportedTarget target;

        private CanApplyPluginByIdUsingPluginAwareApply(SupportedTarget target) {
            this.target = target;
        }

        @Override
        public String getDisplayName() {
            return "can apply plugin by id using apply(plugin: <id>) [" + (Object)((Object)this.target) + "]";
        }

        @Override
        public void doExecute() throws Throwable {
            this.buildScript(this.target.getBuildScriptName()).append("apply plugin: '" + WellBehavedPluginTester.this.getQualifiedPluginIdUnderTest() + "'");
            this.succeeds(new String[0]);
        }
    }

    private final class AppliesPluginTypeWhenApplyingPluginId
    extends AbstractWellBehavedIntegrationTest {
        private final SupportedTarget target;

        private AppliesPluginTypeWhenApplyingPluginId(SupportedTarget target) {
            this.target = target;
        }

        @Override
        public String getDisplayName() {
            return "applies plugin type when applying plugin id [" + (Object)((Object)this.target) + "]";
        }

        @Override
        public void doExecute() throws Throwable {
            this.buildScript(this.target.getBuildScriptName()).append("assert plugins.withType(Class.forName('" + WellBehavedPluginTester.this.getPluginTypeUnderTest().getTypeName() + "')).size() == 0", "apply plugin: '" + WellBehavedPluginTester.this.getQualifiedPluginIdUnderTest() + "'", "assert plugins.withType(Class.forName('" + WellBehavedPluginTester.this.getPluginTypeUnderTest().getTypeName() + "')).size() == 1");
            this.succeeds(new String[0]);
        }
    }

    private static class BuildScript {
        private final Path buildScriptPath;

        private BuildScript(Path buildScriptPath) {
            this.buildScriptPath = buildScriptPath;
        }

        public BuildScript append(String ... l) {
            Files.write(this.buildScriptPath, Arrays.asList(l), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            return this;
        }

        public File toFile() {
            return this.buildScriptPath.toFile();
        }
    }

    private abstract class AbstractWellBehavedIntegrationTest
    extends FileTesterTestCase {
        protected GradleRunner runner;

        private AbstractWellBehavedIntegrationTest() {
        }

        protected GradleRunner newRunner() {
            GradleRunner runner = GradleRunner.create((GradleExecutor)GradleExecutor.gradleTestKit()).inDirectory(this.getWorkingDirectory().toFile()).configure(this::configureRunnerPluginDslClasspath).configure(this::configureRunnerBuildscriptClasspath).usingInitScript(this.getInitFile().toFile());
            this.getInitFile().append("initscript {", "  dependencies {", "    classpath files(" + runner.getPluginClasspath().stream().map(File::toURI).map(Objects::toString).map(this::quote).collect(Collectors.joining(", ")) + ")", "  }", "}");
            return runner;
        }

        @Override
        public void setUp() throws Throwable {
            super.setUp();
            this.runner = this.newRunner();
        }

        protected final BuildResult succeeds(String ... tasks) {
            return this.runner.withTasks(tasks).build();
        }

        protected final BuildResult fails(String ... tasks) {
            return this.runner.withTasks(tasks).buildAndFail();
        }

        protected final BuildScript getBuildFile() {
            return new BuildScript(this.getWorkingDirectory().resolve("build.gradle"));
        }

        protected final BuildScript getSettingsFile() {
            return new BuildScript(this.getWorkingDirectory().resolve("settings.gradle"));
        }

        protected final BuildScript getInitFile() {
            return new BuildScript(this.getWorkingDirectory().resolve("init.gradle"));
        }

        protected BuildScript buildScript(String path) {
            return new BuildScript(this.getWorkingDirectory().resolve(path));
        }

        private GradleRunner configureRunnerPluginDslClasspath(GradleRunner runner) {
            if (Thread.currentThread().getContextClassLoader().getResource("plugin-under-test-metadata.properties") == null) {
                return runner.withPluginClasspath((Iterable)Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).map(File::new).collect(Collectors.toList()));
            }
            return runner.withPluginClasspath();
        }

        private GradleRunner configureRunnerBuildscriptClasspath(GradleRunner runner) {
            BuildScript initScript = new BuildScript(this.getWorkingDirectory().resolve("classpath.init.gradle"));
            initScript.append("initscript {", "  dependencies {", "    classpath files(" + runner.getPluginClasspath().stream().map(File::toURI).map(Objects::toString).map(this::quote).collect(Collectors.joining(", ")) + ")", "  }", "}", "beforeSettings { settings ->", "  settings.buildscript.dependencies {", "    classpath files(" + runner.getPluginClasspath().stream().map(File::toURI).map(Objects::toString).map(this::quote).collect(Collectors.joining(", ")) + ")", "  }", "  settings.include('a', 'b', 'c')", "}");
            return runner.usingInitScript(initScript.toFile());
        }

        private String quote(String s) {
            return "\"" + s + "\"";
        }
    }

    private abstract class FileTesterTestCase
    implements TestCase {
        private final TestNameTestDirectoryProvider testDirectory;
        private boolean shouldCleanup;

        private FileTesterTestCase() {
            this.testDirectory = TestNameTestDirectoryProvider.newInstance(this.getDisplayName(), WellBehavedPluginTester.this);
            this.shouldCleanup = true;
        }

        protected Path getWorkingDirectory() {
            return this.testDirectory.getTestDirectory();
        }

        @Override
        public final void execute() throws Throwable {
            try {
                this.doExecute();
            }
            catch (TestAbortedException t) {
                throw t;
            }
            catch (Throwable t) {
                if (LEAVE_WORKSPACE_BEHIND_ON_ERRORS) {
                    this.shouldCleanup = false;
                }
                throw t;
            }
        }

        protected abstract void doExecute() throws Throwable;

        @Override
        public void tearDown() throws Throwable {
            if (this.shouldCleanup) {
                this.testDirectory.cleanup();
            }
        }
    }

    public static enum SupportedTarget {
        Project("build.gradle"),
        Settings("settings.gradle"),
        Init("init.gradle");

        private final String buildScriptName;

        private SupportedTarget(String buildScriptName) {
            this.buildScriptName = buildScriptName;
        }

        private String getBuildScriptName() {
            return this.buildScriptName;
        }
    }
}

