/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.grava.testing;

import dev.gradleplugins.grava.testing.TestCase;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.opentest4j.MultipleFailuresError;
import org.opentest4j.TestAbortedException;

public abstract class AbstractTester {
    protected final List<TestCase> getTesters() {
        ArrayList<TestCase> result = new ArrayList<TestCase>();
        this.collectTesters(result);
        return result;
    }

    protected abstract void collectTesters(List<TestCase> var1);

    protected final void executeAllTestCases() {
        ArrayList failures = new ArrayList();
        this.stream().forEach(testCase -> {
            try {
                testCase.setUp();
                try {
                    testCase.execute();
                }
                finally {
                    testCase.tearDown();
                }
            }
            catch (TestAbortedException testAbortedException) {
            }
            catch (Throwable throwable) {
                failures.add(new TestCaseFailure(testCase.getDisplayName(), throwable));
            }
        });
        if (!failures.isEmpty()) {
            throw new MultipleFailuresError("Plugin is not well-behaved", failures);
        }
    }

    public final Stream<TestCase> stream() {
        return this.getTesters().stream();
    }

    private static final class TestCaseFailure
    extends RuntimeException {
        public TestCaseFailure(String displayName, Throwable throwable) {
            super(displayName, throwable);
        }
    }
}

