/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.grava.testing.file;

import dev.gradleplugins.grava.testing.file.TestDirectoryProvider;
import dev.gradleplugins.grava.testing.util.RetryUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Arrays;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

abstract class AbstractTestDirectoryProvider
implements TestDirectoryProvider,
AutoCloseable {
    protected final Path root;
    private final String className;
    private static final Random RANDOM = new Random();
    private static final int ALL_DIGITS_AND_LETTERS_RADIX = 36;
    private static final int MAX_RANDOM_PART_VALUE = Integer.valueOf("zzzzz", 36);
    private static final Pattern WINDOWS_RESERVED_NAMES = Pattern.compile("(con)|(prn)|(aux)|(nul)|(com\\d)|(lpt\\d)", 2);
    private String prefix;
    private Path dir;
    private boolean cleanup = true;
    private boolean suppressCleanupErrors = false;

    protected AbstractTestDirectoryProvider(Path root, Class<?> testClass) {
        this.root = root;
        this.className = AbstractTestDirectoryProvider.shortenPath(testClass.getSimpleName(), 16);
    }

    @Override
    public void suppressCleanup() {
        this.cleanup = false;
    }

    @Override
    public void suppressCleanupErrors() {
        this.suppressCleanupErrors = true;
    }

    public boolean isCleanup() {
        return this.cleanup;
    }

    public void cleanup() throws IOException {
        if (this.cleanup && this.dir != null && Files.exists(this.dir, new LinkOption[0])) {
            try {
                RetryUtils.retry(100, Duration.ofMillis(100L), () -> FileUtils.forceDelete((File)this.dir.toFile()));
            }
            catch (InterruptedException e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.cleanup();
    }

    protected void init(String methodName) {
        if (methodName == null) {
            methodName = this.getClass().getSimpleName();
        }
        if (this.prefix == null) {
            String safeMethodName = AbstractTestDirectoryProvider.shortenPath(methodName.replaceAll("[^\\w]", "_"), 16);
            this.prefix = String.format("%s/%s", this.className, safeMethodName);
        }
    }

    private static String shortenPath(String longName, int expectedMaxLength) {
        if (longName.length() <= expectedMaxLength) {
            return longName;
        }
        return longName.substring(0, expectedMaxLength - 5) + "." + longName.substring(longName.length() - 4);
    }

    @Override
    public Path getTestDirectory() {
        if (this.dir == null) {
            this.dir = this.createUniqueTestDirectory();
        }
        return this.dir;
    }

    private Path createUniqueTestDirectory() {
        String randomPrefix;
        while (WINDOWS_RESERVED_NAMES.matcher(randomPrefix = Integer.toString(RANDOM.nextInt(MAX_RANDOM_PART_VALUE), 36)).matches()) {
        }
        Path dir = this.root.resolve(this.getPrefix()).resolve(randomPrefix);
        try {
            return Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            return (Path)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private String getPrefix() {
        if (this.prefix == null) {
            this.prefix = this.className;
        }
        return this.prefix;
    }

    public Path file(Object ... path) {
        return this.getTestDirectory().resolve(Arrays.stream(path).map(Object::toString).collect(Collectors.joining(File.separator)));
    }

    public Path createFile(Object ... path) {
        Path result = this.file(path);
        try {
            Files.createDirectories(result.getParent(), new FileAttribute[0]);
            return Files.createFile(result, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Path createDirectory(Object ... path) {
        try {
            return Files.createDirectories(this.file(path), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Path getRoot() {
        return this.root;
    }
}

