/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.grava.testing;

import dev.gradleplugins.grava.testing.TestCase;
import dev.gradleplugins.grava.testing.file.TestNameTestDirectoryProvider;
import dev.gradleplugins.grava.testing.util.ProjectTestUtils;
import dev.gradleplugins.runnerkit.GradleExecutor;
import dev.gradleplugins.runnerkit.GradleRunner;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.opentest4j.MultipleFailuresError;
import org.opentest4j.TestAbortedException;

public final class WellBehavedPluginTester {
    private String qualifiedPluginId;
    private Class<? extends Plugin<?>> pluginType;

    private String getQualifiedPluginIdUnderTest() {
        if (this.qualifiedPluginId == null) {
            throw new TestAbortedException();
        }
        return this.qualifiedPluginId;
    }

    private Class<? extends Plugin<?>> getPluginTypeUnderTest() {
        if (this.pluginType == null) {
            throw new TestAbortedException();
        }
        return this.pluginType;
    }

    public WellBehavedPluginTester qualifiedPluginId(String qualifiedPluginId) {
        this.qualifiedPluginId = qualifiedPluginId;
        return this;
    }

    public WellBehavedPluginTester pluginType(Class<? extends Plugin<?>> pluginType) {
        this.pluginType = pluginType;
        return this;
    }

    private Collection<TestCase> getTesters() {
        ArrayList<TestCase> testers = new ArrayList<TestCase>();
        testers.add(new AppliedPluginIdIsExpectedType());
        testers.add(new CanApplyByIdViaPluginDsl());
        testers.add(new CanApplyPluginByIdUsingProjectApply());
        testers.add(new CanApplyPluginByTypeUsingProjectApply());
        testers.add(new CanExecuteHelpTask());
        testers.add(new CanExecuteTasksTask());
        testers.add(new DoesNotRealizeTask());
        return testers;
    }

    public void testWellBehavedPlugin() {
        if (this.qualifiedPluginId == null && this.pluginType == null) {
            throw new AssertionError((Object)"Missing qualified plugin id and/or plugin type");
        }
        ArrayList failures = new ArrayList();
        this.stream().forEach(testCase -> {
            try {
                testCase.setUp();
                try {
                    testCase.execute();
                }
                finally {
                    testCase.tearDown();
                }
            }
            catch (TestAbortedException testAbortedException) {
            }
            catch (Throwable throwable) {
                failures.add(new TestCaseFailure(testCase.getDisplayName(), throwable));
            }
        });
        if (!failures.isEmpty()) {
            throw new MultipleFailuresError("Plugin is not well-behaved", failures);
        }
    }

    public Stream<TestCase> stream() {
        return this.getTesters().stream();
    }

    private void executeTask(String task, File workingDirectory) {
        GradleRunner runner = GradleRunner.create((GradleExecutor)GradleExecutor.gradleTestKit()).inDirectory(workingDirectory).withTasks(new String[]{task});
        runner = this.getClass().getResource("plugin-under-test-metadata.properties") == null ? runner.withPluginClasspath((Iterable)Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).map(File::new).collect(Collectors.toList())) : runner.withPluginClasspath();
        runner.build();
    }

    private void aBuildScriptApplyingPlugin(File workingDirectory) throws Exception {
        File buildFile = new File(workingDirectory, "build.gradle");
        StringWriter content = new StringWriter();
        PrintWriter out = new PrintWriter(content);
        out.println("plugins {");
        out.println("    id '" + this.getQualifiedPluginIdUnderTest() + "'");
        out.println("}");
        Files.write(buildFile.toPath(), content.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private class DoesNotRealizeTask
    extends FileTesterTestCase {
        private DoesNotRealizeTask() {
        }

        protected List<String> getRealizedTaskPaths() {
            return Collections.singletonList(":help");
        }

        private GradleRunner configureRunner(GradleRunner runner) {
            if (this.getClass().getResource("plugin-under-test-metadata.properties") == null) {
                return runner.withPluginClasspath((Iterable)Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).map(File::new).collect(Collectors.toList()));
            }
            return runner.withPluginClasspath();
        }

        private List<String> getRealizedQuotedTaskPaths() {
            return this.getRealizedTaskPaths().stream().map(this::quoted).collect(Collectors.toList());
        }

        private String quoted(String s) {
            return "'" + s + "'";
        }

        @Override
        public String getDisplayName() {
            return "does not realize task";
        }

        @Override
        public void execute() throws Throwable {
            StringWriter content = new StringWriter();
            PrintWriter out = new PrintWriter(content);
            out.println("plugins {");
            out.println("    id '" + WellBehavedPluginTester.this.getQualifiedPluginIdUnderTest() + "'");
            out.println("}");
            out.println();
            out.println("def configuredTasks = []");
            out.println("tasks.configureEach {");
            out.println("    configuredTasks << it");
            out.println("}");
            out.println();
            out.println("gradle.buildFinished {");
            out.println(" println 'wat'");
            out.println("    def configuredTaskPaths = configuredTasks*.path");
            out.println();
            out.println("    // TODO: Log warning if getRealizedTaskPaths() is different than ':help'");
            out.println("    configuredTaskPaths.removeAll([" + String.join((CharSequence)", ", this.getRealizedQuotedTaskPaths()) + "])");
            out.println("    assert configuredTaskPaths == []");
            out.println("}");
            File buildFile = new File(this.getWorkingDirectory(), "build.gradle");
            Files.write(buildFile.toPath(), content.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            GradleRunner.create((GradleExecutor)GradleExecutor.gradleTestKit()).inDirectory(this.getWorkingDirectory()).configure(this::configureRunner).withTasks(new String[]{"help"}).build();
        }
    }

    private class CanExecuteTasksTask
    extends FileTesterTestCase {
        private CanExecuteTasksTask() {
        }

        @Override
        public String getDisplayName() {
            return "can execute tasks task";
        }

        @Override
        public void execute() throws Throwable {
            WellBehavedPluginTester.this.aBuildScriptApplyingPlugin(this.getWorkingDirectory());
            WellBehavedPluginTester.this.executeTask("tasks", this.getWorkingDirectory());
        }
    }

    private class CanExecuteHelpTask
    extends FileTesterTestCase {
        private CanExecuteHelpTask() {
        }

        @Override
        public String getDisplayName() {
            return "can execute help task";
        }

        @Override
        public void execute() throws Throwable {
            WellBehavedPluginTester.this.aBuildScriptApplyingPlugin(this.getWorkingDirectory());
            WellBehavedPluginTester.this.executeTask("help", this.getWorkingDirectory());
        }
    }

    public class CanApplyByIdViaPluginDsl
    extends FileTesterTestCase {
        @Override
        public String getDisplayName() {
            return "can apply by id via plugin DSL";
        }

        @Override
        public void execute() throws Throwable {
            File buildFile = new File(this.getWorkingDirectory(), "build.gradle");
            StringWriter content = new StringWriter();
            PrintWriter out = new PrintWriter(content);
            out.println("plugins {");
            out.println("    id '" + WellBehavedPluginTester.this.getQualifiedPluginIdUnderTest() + "'");
            out.println("}");
            Files.write(buildFile.toPath(), content.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.configureRunner(GradleRunner.create((GradleExecutor)GradleExecutor.gradleTestKit()).inDirectory(this.getWorkingDirectory())).build();
        }

        private GradleRunner configureRunner(GradleRunner runner) {
            if (this.getClass().getResource("plugin-under-test-metadata.properties") == null) {
                return runner.withPluginClasspath((Iterable)Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).map(File::new).collect(Collectors.toList()));
            }
            return runner.withPluginClasspath();
        }
    }

    public class CanApplyPluginByTypeUsingProjectApply
    implements TestCase {
        @Override
        public String getDisplayName() {
            return "can apply plugin type type using project.apply(plugin: <class>)";
        }

        @Override
        public void execute() throws Throwable {
            Project project = ProjectTestUtils.rootProject();
            project.apply(Collections.singletonMap("plugin", WellBehavedPluginTester.this.getPluginTypeUnderTest()));
        }
    }

    private final class AppliedPluginIdIsExpectedType
    implements TestCase {
        private AppliedPluginIdIsExpectedType() {
        }

        @Override
        public String getDisplayName() {
            return "applied plugin id has expected type";
        }

        @Override
        public void execute() throws Throwable {
            Project project = ProjectTestUtils.rootProject();
            project.apply(Collections.singletonMap("plugin", WellBehavedPluginTester.this.getQualifiedPluginIdUnderTest()));
            Plugin pluginById = project.getPlugins().findPlugin(WellBehavedPluginTester.this.getQualifiedPluginIdUnderTest());
            MatcherAssert.assertThat((Object)pluginById, (Matcher)Matchers.isA((Class)WellBehavedPluginTester.this.getPluginTypeUnderTest()));
        }
    }

    private final class CanApplyPluginByIdUsingProjectApply
    implements TestCase {
        private CanApplyPluginByIdUsingProjectApply() {
        }

        @Override
        public String getDisplayName() {
            return "can apply plugin by id using project.apply(plugin: <id>)";
        }

        @Override
        public void execute() throws Throwable {
            Project project = ProjectTestUtils.rootProject();
            project.apply(Collections.singletonMap("plugin", WellBehavedPluginTester.this.getQualifiedPluginIdUnderTest()));
        }
    }

    private abstract class FileTesterTestCase
    implements TestCase {
        private final TestNameTestDirectoryProvider testDirectory;

        private FileTesterTestCase() {
            this.testDirectory = TestNameTestDirectoryProvider.newInstance(this.getDisplayName(), WellBehavedPluginTester.this);
        }

        protected File getWorkingDirectory() {
            return this.testDirectory.getTestDirectory().toFile();
        }

        @Override
        public void tearDown() throws Throwable {
            this.testDirectory.cleanup();
        }
    }

    public static final class TestCaseFailure
    extends RuntimeException {
        public TestCaseFailure(String displayName, Throwable throwable) {
            super(displayName, throwable);
        }
    }
}

