/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.grava.publish.metadata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import dev.gradleplugins.grava.publish.metadata.GradleModuleMetadata;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class GradleModuleMetadataWriter
implements Closeable {
    private static final Type CAPABILITIES_TYPE = new TypeToken<List<GradleModuleMetadata.Capability>>(){}.getType();
    private static final Type EXCLUDES_TYPE = new TypeToken<Set<GradleModuleMetadata.Exclude>>(){}.getType();
    private static final Type ATTRIBUTES_TYPE = new TypeToken<List<GradleModuleMetadata.Attribute>>(){}.getType();
    private static final Type DEPENDENCIES_TYPE = new TypeToken<List<GradleModuleMetadata.Dependency>>(){}.getType();
    private static final Type DEPENDENCY_CONSTRAINTS_TYPE = new TypeToken<List<GradleModuleMetadata.DependencyConstraint>>(){}.getType();
    private static final Type FILES_TYPE = new TypeToken<List<GradleModuleMetadata.File>>(){}.getType();
    private final Writer writer;

    public GradleModuleMetadataWriter(Writer writer) {
        this.writer = writer;
    }

    public void write(GradleModuleMetadata metadata) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ATTRIBUTES_TYPE, (Object)AttributesSerializer.INSTANCE).registerTypeAdapter(DEPENDENCIES_TYPE, (Object)CollectionSerializer.INSTANCE).registerTypeAdapter(EXCLUDES_TYPE, (Object)CollectionSerializer.INSTANCE).registerTypeAdapter(CAPABILITIES_TYPE, (Object)CollectionSerializer.INSTANCE).registerTypeAdapter(DEPENDENCY_CONSTRAINTS_TYPE, (Object)CollectionSerializer.INSTANCE).registerTypeAdapter(FILES_TYPE, (Object)CollectionSerializer.INSTANCE).create();
        this.writer.write(gson.toJson((Object)metadata));
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private static enum AttributesSerializer implements JsonSerializer<List<GradleModuleMetadata.Attribute>>
    {
        INSTANCE;


        public JsonElement serialize(List<GradleModuleMetadata.Attribute> src, Type typeOfSrc, JsonSerializationContext context) {
            if (src.isEmpty()) {
                return null;
            }
            JsonObject map = new JsonObject();
            src.forEach(a -> map.addProperty(a.getName(), a.getValue().toString()));
            return map;
        }
    }

    private static enum CollectionSerializer implements JsonSerializer<Collection<?>>
    {
        INSTANCE;


        public JsonElement serialize(Collection<?> src, Type typeOfSrc, JsonSerializationContext context) {
            if (src.isEmpty()) {
                return null;
            }
            return context.serialize(src);
        }
    }
}

