/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.grava.publish.metadata;

import dev.gradleplugins.grava.publish.metadata.GradleModuleMetadataWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class GradleModuleMetadata {
    @NonNull
    private final String formatVersion;
    @Nullable
    private final Component component;
    @Nullable
    private final CreatedBy createdBy;
    @NonNull
    private final List<Variant> variants;

    public Optional<Component> getComponent() {
        return Optional.ofNullable(this.component);
    }

    public Optional<CreatedBy> getCreatedBy() {
        return Optional.ofNullable(this.createdBy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GradleModuleMetadataWriter newWriter(java.io.File file) throws FileNotFoundException {
        return new GradleModuleMetadataWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
    }

    public static void withWriter(java.io.File file, Consumer<? super GradleModuleMetadataWriter> action) throws IOException {
        try (GradleModuleMetadataWriter writer = GradleModuleMetadata.newWriter(file);){
            action.accept(writer);
        }
    }

    @NonNull
    public String getFormatVersion() {
        return this.formatVersion;
    }

    @NonNull
    public List<Variant> getVariants() {
        return this.variants;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleModuleMetadata)) {
            return false;
        }
        GradleModuleMetadata other = (GradleModuleMetadata)o;
        String this$formatVersion = this.getFormatVersion();
        String other$formatVersion = other.getFormatVersion();
        if (this$formatVersion == null ? other$formatVersion != null : !this$formatVersion.equals(other$formatVersion)) {
            return false;
        }
        Optional<Component> this$component = this.getComponent();
        Optional<Component> other$component = other.getComponent();
        if (this$component == null ? other$component != null : !((Object)this$component).equals(other$component)) {
            return false;
        }
        Optional<CreatedBy> this$createdBy = this.getCreatedBy();
        Optional<CreatedBy> other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
            return false;
        }
        List<Variant> this$variants = this.getVariants();
        List<Variant> other$variants = other.getVariants();
        return !(this$variants == null ? other$variants != null : !((Object)this$variants).equals(other$variants));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $formatVersion = this.getFormatVersion();
        result = result * 59 + ($formatVersion == null ? 43 : $formatVersion.hashCode());
        Optional<Component> $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : ((Object)$component).hashCode());
        Optional<CreatedBy> $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
        List<Variant> $variants = this.getVariants();
        result = result * 59 + ($variants == null ? 43 : ((Object)$variants).hashCode());
        return result;
    }

    public String toString() {
        return "GradleModuleMetadata(formatVersion=" + this.getFormatVersion() + ", component=" + this.getComponent() + ", createdBy=" + this.getCreatedBy() + ", variants=" + this.getVariants() + ")";
    }

    private GradleModuleMetadata(@NonNull String formatVersion, @Nullable Component component, @Nullable CreatedBy createdBy, @NonNull List<Variant> variants) {
        if (formatVersion == null) {
            throw new NullPointerException("formatVersion is marked non-null but is null");
        }
        if (variants == null) {
            throw new NullPointerException("variants is marked non-null but is null");
        }
        this.formatVersion = formatVersion;
        this.component = component;
        this.createdBy = createdBy;
        this.variants = variants;
    }

    public static final class Builder {
        private String formatVersion;
        private Component component;
        private CreatedBy createdBy;
        private final List<Variant> variants = new ArrayList<Variant>();

        public Builder formatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
            return this;
        }

        public Builder component(Component component) {
            this.component = component;
            return this;
        }

        public Builder createdBy(CreatedBy createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder variant(Variant variant) {
            this.variants.add(variant);
            return this;
        }

        public Builder localVariant(Consumer<? super LocalVariant.Builder> builderConsumer) {
            LocalVariant.Builder builder = LocalVariant.builder();
            builderConsumer.accept(builder);
            return this.variant(builder.build());
        }

        public Builder remoteVariant(Consumer<? super RemoteVariant.Builder> builderConsumer) {
            RemoteVariant.Builder builder = RemoteVariant.builder();
            builderConsumer.accept(builder);
            return this.variant(builder.build());
        }

        public GradleModuleMetadata build() {
            return new GradleModuleMetadata(this.formatVersion, this.component, this.createdBy, this.variants);
        }
    }

    public static final class AvailableAt {
        private final String url;
        private final String group;
        private final String module;
        private final String version;

        public static Builder builder() {
            return new Builder();
        }

        public String getUrl() {
            return this.url;
        }

        public String getGroup() {
            return this.group;
        }

        public String getModule() {
            return this.module;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AvailableAt)) {
                return false;
            }
            AvailableAt other = (AvailableAt)o;
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$module = this.getModule();
            String other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "GradleModuleMetadata.AvailableAt(url=" + this.getUrl() + ", group=" + this.getGroup() + ", module=" + this.getModule() + ", version=" + this.getVersion() + ")";
        }

        private AvailableAt(String url, String group, String module, String version) {
            this.url = url;
            this.group = group;
            this.module = module;
            this.version = version;
        }

        public static final class Builder {
            private String url;
            private String group;
            private String module;
            private String version;

            public Builder url(String url) {
                this.url = Objects.requireNonNull(url);
                return this;
            }

            public Builder group(String group) {
                this.group = Objects.requireNonNull(group);
                return this;
            }

            public Builder module(String module) {
                this.module = Objects.requireNonNull(module);
                return this;
            }

            public Builder version(String version) {
                this.version = Objects.requireNonNull(version);
                return this;
            }

            public AvailableAt build() {
                return new AvailableAt(this.url, this.group, this.module, this.version);
            }
        }
    }

    public static final class File {
        private final String name;
        private final String url;
        private final long size;
        private final String sha1;
        private final String md5;

        public static Builder builder() {
            return new Builder();
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public long getSize() {
            return this.size;
        }

        public String getSha1() {
            return this.sha1;
        }

        public String getMd5() {
            return this.md5;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof File)) {
                return false;
            }
            File other = (File)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$sha1 = this.getSha1();
            String other$sha1 = other.getSha1();
            if (this$sha1 == null ? other$sha1 != null : !this$sha1.equals(other$sha1)) {
                return false;
            }
            String this$md5 = this.getMd5();
            String other$md5 = other.getMd5();
            return !(this$md5 == null ? other$md5 != null : !this$md5.equals(other$md5));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $size = this.getSize();
            result = result * 59 + (int)($size >>> 32 ^ $size);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $sha1 = this.getSha1();
            result = result * 59 + ($sha1 == null ? 43 : $sha1.hashCode());
            String $md5 = this.getMd5();
            result = result * 59 + ($md5 == null ? 43 : $md5.hashCode());
            return result;
        }

        public String toString() {
            return "GradleModuleMetadata.File(name=" + this.getName() + ", url=" + this.getUrl() + ", size=" + this.getSize() + ", sha1=" + this.getSha1() + ", md5=" + this.getMd5() + ")";
        }

        private File(String name, String url, long size, String sha1, String md5) {
            this.name = name;
            this.url = url;
            this.size = size;
            this.sha1 = sha1;
            this.md5 = md5;
        }

        public static final class Builder {
            private String name;
            private String url;
            private long sizeInByte;
            private String sha1;
            private String md5;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public Builder size(long sizeInByte) {
                this.sizeInByte = sizeInByte;
                return this;
            }

            public Builder sha1(String sha1) {
                this.sha1 = sha1;
                return this;
            }

            public Builder md5(String md5) {
                this.md5 = md5;
                return this;
            }

            public File build() {
                return new File(this.name, this.url, this.sizeInByte, this.sha1, this.md5);
            }
        }
    }

    public static final class DependencyConstraint {
        private final String group;
        private final String module;
        @Nullable
        private final Version version;
        private final List<Attribute> attributes;
        @Nullable
        private final String reason;

        public static DependencyConstraint ofDependencyConstraint(String group, String module) {
            return DependencyConstraint.builder().group(group).module(module).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getGroup() {
            return this.group;
        }

        public String getModule() {
            return this.module;
        }

        @Nullable
        public Version getVersion() {
            return this.version;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        @Nullable
        public String getReason() {
            return this.reason;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyConstraint)) {
                return false;
            }
            DependencyConstraint other = (DependencyConstraint)o;
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$module = this.getModule();
            String other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            Version this$version = this.getVersion();
            Version other$version = other.getVersion();
            if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
                return false;
            }
            List<Attribute> this$attributes = this.getAttributes();
            List<Attribute> other$attributes = other.getAttributes();
            if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            Version $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            List<Attribute> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            return result;
        }

        public String toString() {
            return "GradleModuleMetadata.DependencyConstraint(group=" + this.getGroup() + ", module=" + this.getModule() + ", version=" + this.getVersion() + ", attributes=" + this.getAttributes() + ", reason=" + this.getReason() + ")";
        }

        private DependencyConstraint(String group, String module, @Nullable Version version, List<Attribute> attributes, @Nullable String reason) {
            this.group = group;
            this.module = module;
            this.version = version;
            this.attributes = attributes;
            this.reason = reason;
        }

        public static final class Builder {
            private String group;
            private String module;
            private Version version;
            private final List<Attribute> attributes = new ArrayList<Attribute>();
            private String reason;

            public Builder group(String group) {
                this.group = group;
                return this;
            }

            public Builder module(String module) {
                this.module = module;
                return this;
            }

            public Builder version(Version version) {
                this.version = version;
                return this;
            }

            public Builder attribute(Attribute attribute) {
                this.attributes.add(attribute);
                return this;
            }

            public Builder reason(String reason) {
                this.reason = reason;
                return this;
            }

            public DependencyConstraint build() {
                return new DependencyConstraint(this.group, this.module, this.version, this.attributes, this.reason);
            }
        }
    }

    public static final class Version {
        @Nullable
        private final String requires;
        @Nullable
        private final String strictly;
        @Nullable
        private final String preferred;
        private final List<String> rejects;

        public Optional<String> getRequires() {
            return Optional.ofNullable(this.requires);
        }

        public Optional<String> getStrictly() {
            return Optional.ofNullable(this.strictly);
        }

        public Optional<String> getPreferred() {
            return Optional.ofNullable(this.preferred);
        }

        public static Version requires(String v) {
            return Version.builder().requires(v).build();
        }

        public static Version strictly(String v) {
            return Version.builder().strictly(v).build();
        }

        public static Version preferred(String v) {
            return Version.builder().preferred(v).build();
        }

        public static Version rejects(String ... v) {
            return Version.builder().rejects(Arrays.asList(v)).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public List<String> getRejects() {
            return this.rejects;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Version)) {
                return false;
            }
            Version other = (Version)o;
            Optional<String> this$requires = this.getRequires();
            Optional<String> other$requires = other.getRequires();
            if (this$requires == null ? other$requires != null : !((Object)this$requires).equals(other$requires)) {
                return false;
            }
            Optional<String> this$strictly = this.getStrictly();
            Optional<String> other$strictly = other.getStrictly();
            if (this$strictly == null ? other$strictly != null : !((Object)this$strictly).equals(other$strictly)) {
                return false;
            }
            Optional<String> this$preferred = this.getPreferred();
            Optional<String> other$preferred = other.getPreferred();
            if (this$preferred == null ? other$preferred != null : !((Object)this$preferred).equals(other$preferred)) {
                return false;
            }
            List<String> this$rejects = this.getRejects();
            List<String> other$rejects = other.getRejects();
            return !(this$rejects == null ? other$rejects != null : !((Object)this$rejects).equals(other$rejects));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $requires = this.getRequires();
            result = result * 59 + ($requires == null ? 43 : ((Object)$requires).hashCode());
            Optional<String> $strictly = this.getStrictly();
            result = result * 59 + ($strictly == null ? 43 : ((Object)$strictly).hashCode());
            Optional<String> $preferred = this.getPreferred();
            result = result * 59 + ($preferred == null ? 43 : ((Object)$preferred).hashCode());
            List<String> $rejects = this.getRejects();
            result = result * 59 + ($rejects == null ? 43 : ((Object)$rejects).hashCode());
            return result;
        }

        public String toString() {
            return "GradleModuleMetadata.Version(requires=" + this.getRequires() + ", strictly=" + this.getStrictly() + ", preferred=" + this.getPreferred() + ", rejects=" + this.getRejects() + ")";
        }

        private Version(@Nullable String requires, @Nullable String strictly, @Nullable String preferred, List<String> rejects) {
            this.requires = requires;
            this.strictly = strictly;
            this.preferred = preferred;
            this.rejects = rejects;
        }

        public static final class Builder {
            private String requires;
            private String strictly;
            private String preferred;
            private final List<String> rejects = new ArrayList<String>();

            public Builder requires(String requires) {
                this.requires = requires;
                return this;
            }

            public Builder strictly(String strictly) {
                this.strictly = strictly;
                return this;
            }

            public Builder preferred(String preferred) {
                this.preferred = preferred;
                return this;
            }

            public Builder reject(String reject) {
                this.rejects.add(reject);
                return this;
            }

            public Builder rejects(List<String> rejects) {
                this.rejects.clear();
                this.rejects.addAll(rejects);
                return this;
            }

            public Version build() {
                return new Version(this.requires, this.strictly, this.preferred, this.rejects);
            }
        }
    }

    public static final class Capability {
        private final String group;
        private final String name;
        @Nullable
        private final String version;

        public Optional<String> getVersion() {
            return Optional.ofNullable(this.version);
        }

        public static Capability ofCapability(String group, String name) {
            return new Capability(group, name, null);
        }

        public static Capability ofCapability(String group, String name, String version) {
            return new Capability(group, name, version);
        }

        public String getGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Capability)) {
                return false;
            }
            Capability other = (Capability)o;
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Optional<String> this$version = this.getVersion();
            Optional<String> other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Optional<String> $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            return result;
        }

        public String toString() {
            return "GradleModuleMetadata.Capability(group=" + this.getGroup() + ", name=" + this.getName() + ", version=" + this.getVersion() + ")";
        }

        private Capability(String group, String name, @Nullable String version) {
            this.group = group;
            this.name = name;
            this.version = version;
        }
    }

    public static final class Attribute {
        private final String name;
        private final Object value;

        public static Attribute ofAttribute(String name, Object value) {
            return new Attribute(name, value);
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attribute)) {
                return false;
            }
            Attribute other = (Attribute)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "GradleModuleMetadata.Attribute(name=" + this.getName() + ", value=" + this.getValue() + ")";
        }

        private Attribute(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }

    public static final class Exclude {
        private final String group;
        private final String module;

        public static Exclude ofExclude(String group, String module) {
            return new Exclude(group, module);
        }

        public String getGroup() {
            return this.group;
        }

        public String getModule() {
            return this.module;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Exclude)) {
                return false;
            }
            Exclude other = (Exclude)o;
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$module = this.getModule();
            String other$module = other.getModule();
            return !(this$module == null ? other$module != null : !this$module.equals(other$module));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            return result;
        }

        public String toString() {
            return "GradleModuleMetadata.Exclude(group=" + this.getGroup() + ", module=" + this.getModule() + ")";
        }

        private Exclude(String group, String module) {
            this.group = group;
            this.module = module;
        }
    }

    public static final class Dependency {
        private final String group;
        private final String name;
        @Nullable
        private final Version version;
        private final Set<Exclude> excludes;
        @Nullable
        private final String reason;
        private final List<Attribute> attributes;
        private final List<Capability> requestedCapabilities;

        public Optional<Version> getVersion() {
            return Optional.ofNullable(this.version);
        }

        public Optional<String> getReason() {
            return Optional.ofNullable(this.reason);
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }

        public Set<Exclude> getExcludes() {
            return this.excludes;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        public List<Capability> getRequestedCapabilities() {
            return this.requestedCapabilities;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Optional<Version> this$version = this.getVersion();
            Optional<Version> other$version = other.getVersion();
            if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
                return false;
            }
            Set<Exclude> this$excludes = this.getExcludes();
            Set<Exclude> other$excludes = other.getExcludes();
            if (this$excludes == null ? other$excludes != null : !((Object)this$excludes).equals(other$excludes)) {
                return false;
            }
            Optional<String> this$reason = this.getReason();
            Optional<String> other$reason = other.getReason();
            if (this$reason == null ? other$reason != null : !((Object)this$reason).equals(other$reason)) {
                return false;
            }
            List<Attribute> this$attributes = this.getAttributes();
            List<Attribute> other$attributes = other.getAttributes();
            if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
                return false;
            }
            List<Capability> this$requestedCapabilities = this.getRequestedCapabilities();
            List<Capability> other$requestedCapabilities = other.getRequestedCapabilities();
            return !(this$requestedCapabilities == null ? other$requestedCapabilities != null : !((Object)this$requestedCapabilities).equals(other$requestedCapabilities));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Optional<Version> $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            Set<Exclude> $excludes = this.getExcludes();
            result = result * 59 + ($excludes == null ? 43 : ((Object)$excludes).hashCode());
            Optional<String> $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : ((Object)$reason).hashCode());
            List<Attribute> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            List<Capability> $requestedCapabilities = this.getRequestedCapabilities();
            result = result * 59 + ($requestedCapabilities == null ? 43 : ((Object)$requestedCapabilities).hashCode());
            return result;
        }

        public String toString() {
            return "GradleModuleMetadata.Dependency(group=" + this.getGroup() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", excludes=" + this.getExcludes() + ", reason=" + this.getReason() + ", attributes=" + this.getAttributes() + ", requestedCapabilities=" + this.getRequestedCapabilities() + ")";
        }

        private Dependency(String group, String name, @Nullable Version version, Set<Exclude> excludes, @Nullable String reason, List<Attribute> attributes, List<Capability> requestedCapabilities) {
            this.group = group;
            this.name = name;
            this.version = version;
            this.excludes = excludes;
            this.reason = reason;
            this.attributes = attributes;
            this.requestedCapabilities = requestedCapabilities;
        }

        public static final class Builder {
            private String group;
            private String name;
            private Version version;
            private final Set<Exclude> excludes = new HashSet<Exclude>();
            private String reason;
            private final List<Attribute> attributes = new ArrayList<Attribute>();
            private final List<Capability> requestedCapabilities = new ArrayList<Capability>();

            public Builder group(String group) {
                this.group = group;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder version(Version version) {
                this.version = version;
                return this;
            }

            public Builder exclude(Exclude exclude) {
                this.excludes.add(exclude);
                return this;
            }

            public Builder reason(String reason) {
                this.reason = reason;
                return this;
            }

            public Builder attribute(Attribute attribute) {
                this.attributes.add(attribute);
                return this;
            }

            public Builder requestedCapability(Capability capability) {
                this.requestedCapabilities.add(capability);
                return this;
            }

            public Dependency build() {
                return new Dependency(this.group, this.name, this.version, this.excludes, this.reason, this.attributes, this.requestedCapabilities);
            }
        }
    }

    public static final class RemoteVariant
    implements Variant {
        private final String name;
        private final List<Attribute> attributes;
        @Nullable
        private final AvailableAt availableAt;
        private final List<Capability> capabilities;

        public static Builder builder() {
            return new Builder();
        }

        public String getName() {
            return this.name;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        @Nullable
        public AvailableAt getAvailableAt() {
            return this.availableAt;
        }

        public List<Capability> getCapabilities() {
            return this.capabilities;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoteVariant)) {
                return false;
            }
            RemoteVariant other = (RemoteVariant)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<Attribute> this$attributes = this.getAttributes();
            List<Attribute> other$attributes = other.getAttributes();
            if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
                return false;
            }
            AvailableAt this$availableAt = this.getAvailableAt();
            AvailableAt other$availableAt = other.getAvailableAt();
            if (this$availableAt == null ? other$availableAt != null : !((Object)this$availableAt).equals(other$availableAt)) {
                return false;
            }
            List<Capability> this$capabilities = this.getCapabilities();
            List<Capability> other$capabilities = other.getCapabilities();
            return !(this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<Attribute> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            AvailableAt $availableAt = this.getAvailableAt();
            result = result * 59 + ($availableAt == null ? 43 : ((Object)$availableAt).hashCode());
            List<Capability> $capabilities = this.getCapabilities();
            result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
            return result;
        }

        public String toString() {
            return "GradleModuleMetadata.RemoteVariant(name=" + this.getName() + ", attributes=" + this.getAttributes() + ", availableAt=" + this.getAvailableAt() + ", capabilities=" + this.getCapabilities() + ")";
        }

        private RemoteVariant(String name, List<Attribute> attributes, @Nullable AvailableAt availableAt, List<Capability> capabilities) {
            this.name = name;
            this.attributes = attributes;
            this.availableAt = availableAt;
            this.capabilities = capabilities;
        }

        public static final class Builder {
            private String name;
            private final List<Attribute> attributes = new ArrayList<Attribute>();
            private AvailableAt availableAt;
            private final List<Capability> capabilities = new ArrayList<Capability>();

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder attribute(Attribute attribute) {
                this.attributes.add(attribute);
                return this;
            }

            public Builder availableAt(AvailableAt availableAt) {
                this.availableAt = availableAt;
                return this;
            }

            public Builder availableAt(Consumer<? super AvailableAt.Builder> builderConsumer) {
                AvailableAt.Builder builder = AvailableAt.builder();
                builderConsumer.accept(builder);
                return this.availableAt(builder.build());
            }

            public Builder capability(Capability capability) {
                this.capabilities.add(capability);
                return this;
            }

            public RemoteVariant build() {
                return new RemoteVariant(this.name, this.attributes, this.availableAt, this.capabilities);
            }
        }
    }

    public static final class LocalVariant
    implements Variant {
        private final String name;
        private final List<Attribute> attributes;
        private final List<Capability> capabilities;
        private final List<Dependency> dependencies;
        private final List<DependencyConstraint> dependencyConstraints;
        private final List<File> files;

        public static Builder builder() {
            return new Builder();
        }

        public String getName() {
            return this.name;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        public List<Capability> getCapabilities() {
            return this.capabilities;
        }

        public List<Dependency> getDependencies() {
            return this.dependencies;
        }

        public List<DependencyConstraint> getDependencyConstraints() {
            return this.dependencyConstraints;
        }

        public List<File> getFiles() {
            return this.files;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalVariant)) {
                return false;
            }
            LocalVariant other = (LocalVariant)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<Attribute> this$attributes = this.getAttributes();
            List<Attribute> other$attributes = other.getAttributes();
            if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
                return false;
            }
            List<Capability> this$capabilities = this.getCapabilities();
            List<Capability> other$capabilities = other.getCapabilities();
            if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
                return false;
            }
            List<Dependency> this$dependencies = this.getDependencies();
            List<Dependency> other$dependencies = other.getDependencies();
            if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
                return false;
            }
            List<DependencyConstraint> this$dependencyConstraints = this.getDependencyConstraints();
            List<DependencyConstraint> other$dependencyConstraints = other.getDependencyConstraints();
            if (this$dependencyConstraints == null ? other$dependencyConstraints != null : !((Object)this$dependencyConstraints).equals(other$dependencyConstraints)) {
                return false;
            }
            List<File> this$files = this.getFiles();
            List<File> other$files = other.getFiles();
            return !(this$files == null ? other$files != null : !((Object)this$files).equals(other$files));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<Attribute> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            List<Capability> $capabilities = this.getCapabilities();
            result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
            List<Dependency> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            List<DependencyConstraint> $dependencyConstraints = this.getDependencyConstraints();
            result = result * 59 + ($dependencyConstraints == null ? 43 : ((Object)$dependencyConstraints).hashCode());
            List<File> $files = this.getFiles();
            result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
            return result;
        }

        public String toString() {
            return "GradleModuleMetadata.LocalVariant(name=" + this.getName() + ", attributes=" + this.getAttributes() + ", capabilities=" + this.getCapabilities() + ", dependencies=" + this.getDependencies() + ", dependencyConstraints=" + this.getDependencyConstraints() + ", files=" + this.getFiles() + ")";
        }

        private LocalVariant(String name, List<Attribute> attributes, List<Capability> capabilities, List<Dependency> dependencies, List<DependencyConstraint> dependencyConstraints, List<File> files) {
            this.name = name;
            this.attributes = attributes;
            this.capabilities = capabilities;
            this.dependencies = dependencies;
            this.dependencyConstraints = dependencyConstraints;
            this.files = files;
        }

        public static final class Builder {
            private String name;
            private final List<Attribute> attributes = new ArrayList<Attribute>();
            private final List<Capability> capabilities = new ArrayList<Capability>();
            private final List<Dependency> dependencies = new ArrayList<Dependency>();
            private final List<DependencyConstraint> dependencyConstraints = new ArrayList<DependencyConstraint>();
            private final List<File> files = new ArrayList<File>();

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder attribute(Attribute attribute) {
                this.attributes.add(attribute);
                return this;
            }

            public Builder capability(Capability capability) {
                this.capabilities.add(capability);
                return this;
            }

            public Builder dependency(Dependency dependency) {
                this.dependencies.add(dependency);
                return this;
            }

            public Builder dependency(Consumer<? super Dependency.Builder> builderConsumer) {
                Dependency.Builder builder = Dependency.builder();
                builderConsumer.accept(builder);
                return this.dependency(builder.build());
            }

            public Builder dependencyConstraint(DependencyConstraint dependencyConstraint) {
                this.dependencyConstraints.add(dependencyConstraint);
                return this;
            }

            public Builder dependencyConstraint(Consumer<? super DependencyConstraint.Builder> builderConsumer) {
                DependencyConstraint.Builder builder = DependencyConstraint.builder();
                builderConsumer.accept(builder);
                return this.dependencyConstraint(builder.build());
            }

            public Builder file(File file) {
                this.files.add(file);
                return this;
            }

            public Builder file(Consumer<? super File.Builder> builderConsumer) {
                File.Builder builder = File.builder();
                builderConsumer.accept(builder);
                return this.file(builder.build());
            }

            public LocalVariant build() {
                return new LocalVariant(this.name, this.attributes, this.capabilities, this.dependencies, this.dependencyConstraints, this.files);
            }
        }
    }

    public static interface Variant {
    }

    public static final class Gradle {
        private final String version;
        private final String buildId;

        private Gradle(String version, String buildId) {
            this.version = version;
            this.buildId = buildId;
        }

        public static Gradle of(String version, String buildId) {
            return new Gradle(version, buildId);
        }

        public String getVersion() {
            return this.version;
        }

        public String getBuildId() {
            return this.buildId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Gradle)) {
                return false;
            }
            Gradle other = (Gradle)o;
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$buildId = this.getBuildId();
            String other$buildId = other.getBuildId();
            return !(this$buildId == null ? other$buildId != null : !this$buildId.equals(other$buildId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $buildId = this.getBuildId();
            result = result * 59 + ($buildId == null ? 43 : $buildId.hashCode());
            return result;
        }

        public String toString() {
            return "GradleModuleMetadata.Gradle(version=" + this.getVersion() + ", buildId=" + this.getBuildId() + ")";
        }
    }

    public static final class CreatedBy {
        @Nullable
        private final Gradle gradle;

        public Optional<Gradle> getGradle() {
            return Optional.ofNullable(this.gradle);
        }

        public static CreatedBy ofGradle(String version, String buildId) {
            return new CreatedBy(Gradle.of(version, buildId));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreatedBy)) {
                return false;
            }
            CreatedBy other = (CreatedBy)o;
            Optional<Gradle> this$gradle = this.getGradle();
            Optional<Gradle> other$gradle = other.getGradle();
            return !(this$gradle == null ? other$gradle != null : !((Object)this$gradle).equals(other$gradle));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<Gradle> $gradle = this.getGradle();
            result = result * 59 + ($gradle == null ? 43 : ((Object)$gradle).hashCode());
            return result;
        }

        public String toString() {
            return "GradleModuleMetadata.CreatedBy(gradle=" + this.getGradle() + ")";
        }

        private CreatedBy(@Nullable Gradle gradle) {
            this.gradle = gradle;
        }
    }

    public static final class Component {
        private final String group;
        private final String module;
        private final String version;

        public static Component ofComponent(String group, String module, String version) {
            return new Component(group, module, version);
        }

        public String getGroup() {
            return this.group;
        }

        public String getModule() {
            return this.module;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Component)) {
                return false;
            }
            Component other = (Component)o;
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$module = this.getModule();
            String other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "GradleModuleMetadata.Component(group=" + this.getGroup() + ", module=" + this.getModule() + ", version=" + this.getVersion() + ")";
        }

        private Component(String group, String module, String version) {
            this.group = group;
            this.module = module;
            this.version = version;
        }
    }
}

