/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.fixtures.runnerkit;

import dev.gradleplugins.fixtures.file.FileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public interface GradleScriptFixture {
    public File getTestDirectory();

    default public File getBuildFile() {
        return FileSystemUtils.file((File)this.getTestDirectory(), (Object[])new Object[]{this.getBuildFileName()});
    }

    default public String getBuildFileName() {
        return "build.gradle";
    }

    default public File getSettingsFile() {
        return FileSystemUtils.file((File)this.getTestDirectory(), (Object[])new Object[]{this.getSettingsFileName()});
    }

    default public String getSettingsFileName() {
        return "settings.gradle";
    }

    public static List<File> getImplementationClassPath() {
        Properties properties = new Properties();
        try {
            properties.load(GradleScriptFixture.class.getResourceAsStream("/plugin-under-test-metadata.properties"));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return Arrays.stream(properties.get("implementation-classpath").toString().split(File.pathSeparator)).map(File::new).collect(Collectors.toList());
    }

    public static String configurePluginClasspathAsFileCollection() {
        String fileCollectionContent = GradleScriptFixture.getImplementationClassPath().stream().map(file -> "\"" + file.getAbsolutePath().replace("\\", "\\\\") + "\"").collect(Collectors.joining(", "));
        return "files(" + fileCollectionContent + ")";
    }
}

