/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.fixtures.file.FileSystemUtils;
import dev.gradleplugins.runnerkit.AbstractGradleExecutor;
import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.GradleExecutionResult;
import dev.gradleplugins.runnerkit.GradleExecutionResultProcessImpl;
import dev.gradleplugins.runnerkit.GradleUserHomeLookup;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.distributions.WrapperAwareGradleDistribution;
import dev.gradleplugins.runnerkit.providers.GradleExecutionCommandLineProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionEnvironmentVariableProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang3.SystemUtils;

final class GradleExecutorGradleWrapperImpl
extends AbstractGradleExecutor {
    GradleExecutorGradleWrapperImpl() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected GradleExecutionResult doRun(GradleExecutionContext parameters) {
        if (!(parameters.getDistribution().get() instanceof WrapperAwareGradleDistribution)) {
            throw new InvalidRunnerConfigurationException("The Gradle wrapper executor doesn't support customizing the distribution.");
        }
        if (!((List)parameters.getInjectedClasspath().get()).isEmpty()) {
            throw new InvalidRunnerConfigurationException("The Gradle wrapper executor doesn't support injected classpath.");
        }
        File workingDirectory = (File)parameters.getProjectDirectory().orElseGet(() -> ((GradleExecutionProvider)parameters.getWorkingDirectory()).get());
        Path relativePath = ((File)parameters.getGradleUserHomeDirectory().get()).toPath().relativize(GradleUserHomeLookup.gradleUserHome().toPath());
        Properties wrapperProperties = new Properties();
        try (FileInputStream inStream = new FileInputStream(FileSystemUtils.file((File)workingDirectory, (Object[])new Object[]{"gradle/wrapper/gradle-wrapper.properties"}));){
            wrapperProperties.load(inStream);
            wrapperProperties.setProperty("distributionPath", relativePath.toString() + "/wrapper/dists");
            wrapperProperties.setProperty("zipStorePath", relativePath.toString() + "/wrapper/dists");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (FileOutputStream outStream = new FileOutputStream(FileSystemUtils.file((File)workingDirectory, (Object[])new Object[]{"gradle/wrapper/gradle-wrapper.properties"}));){
            wrapperProperties.store(outStream, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (SystemUtils.IS_OS_WINDOWS) {
            builder.command().addAll(Arrays.asList("cmd", "/c", "gradlew.bat"));
            builder.command().addAll(GradleExecutorGradleWrapperImpl.allArguments(parameters));
        } else {
            builder.command().add("./gradlew");
            builder.command().addAll(GradleExecutorGradleWrapperImpl.allArguments(parameters));
        }
        builder.environment().putAll(GradleExecutorGradleWrapperImpl.environmentVariables(parameters));
        builder.directory((File)parameters.getWorkingDirectory().get());
        try {
            Thread[] outputThreads;
            Process process = builder.start();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            TeeOutputStream stdoutStream = new TeeOutputStream((OutputStream)output, (OutputStream)parameters.getStandardOutput().get());
            TeeOutputStream stderrStream = new TeeOutputStream((OutputStream)output, (OutputStream)parameters.getStandardError().get());
            for (Thread thread : outputThreads = new Thread[]{new Thread(GradleExecutorGradleWrapperImpl.copy(process.getInputStream(), (OutputStream)stdoutStream)), new Thread(GradleExecutorGradleWrapperImpl.copy(process.getErrorStream(), (OutputStream)stderrStream))}) {
                thread.start();
            }
            try {
                process.waitFor();
                stdoutStream.flush();
                stderrStream.flush();
                GradleExecutionResultProcessImpl gradleExecutionResultProcessImpl = new GradleExecutionResultProcessImpl(process.exitValue(), output.toString());
                return gradleExecutionResultProcessImpl;
            }
            catch (InterruptedException interruptedException) {
                Thread[] threadArray = outputThreads;
                int n = threadArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Thread thread = threadArray[n2];
                    thread.interrupt();
                    ++n2;
                }
                throw new RuntimeException(interruptedException);
            }
            finally {
                Thread[] threadArray = outputThreads;
                int n = threadArray.length;
                int n3 = 0;
                while (true) {
                    if (n3 >= n) {
                    }
                    Thread thread = threadArray[n3];
                    thread.join();
                    ++n3;
                }
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static Runnable copy(InputStream inStream, OutputStream outStream) {
        return () -> {
            try {
                IOUtils.copy((InputStream)inStream, (OutputStream)outStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private static List<String> allArguments(GradleExecutionContext parameters) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-Dorg.gradle.jvmargs=" + GradleExecutorGradleWrapperImpl.getImplicitBuildJvmArgs().stream().map(it -> "'" + it + "'").collect(Collectors.joining(" ")));
        parameters.getExecutionParameters().stream().filter(GradleExecutionCommandLineProvider.class::isInstance).flatMap(GradleExecutorGradleWrapperImpl::asArguments).forEach(result::add);
        return result;
    }

    private static Stream<String> asArguments(GradleExecutionProvider<?> parameter) {
        return ((GradleExecutionCommandLineProvider)parameter).getAsArguments().stream();
    }

    private static Map<String, String> environmentVariables(GradleExecutionContext parameters) {
        HashMap<String, String> result = new HashMap<String, String>();
        ((Map)parameters.getEnvironmentVariables().orElse(Collections.emptyMap())).forEach((key, value) -> result.put((String)key, value.toString()));
        result.putAll(((GradleExecutionEnvironmentVariableProvider)parameters.getJavaHome()).getAsEnvironmentVariables());
        result.put("GRADLE_USER_HOME", ((File)parameters.getGradleUserHomeDirectory().get()).getAbsolutePath());
        return result;
    }
}

