/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import dev.nokee.core.exec.CommandLineTool;
import dev.nokee.core.exec.CommandLineToolArguments;
import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.CommandLineToolExecutionHandle;
import dev.nokee.core.exec.CommandLineToolInvocationBuilder;
import dev.nokee.core.exec.CommandLineUtils;
import dev.nokee.core.exec.ProcessBuilderEngine;
import dev.nokee.core.exec.internal.DefaultCommandLine;
import dev.nokee.utils.DeferredUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;

public interface CommandLine {
    public CommandLineTool getTool();

    public CommandLineToolArguments getArguments();

    public CommandLineToolInvocationBuilder newInvocation();

    public <T extends CommandLineToolExecutionHandle> T execute(CommandLineToolExecutionEngine<T> var1);

    public ProcessBuilderEngine.Handle execute(@Nullable List<?> var1, File var2);

    public ProcessBuilderEngine.Handle execute();

    public static CommandLine of(Object ... commandLine) {
        return CommandLine.of(Arrays.asList(commandLine));
    }

    public static CommandLine of(@NonNull List<?> commandLine) {
        if (commandLine == null) {
            throw new NullPointerException("commandLine is marked non-null but is null");
        }
        Iterator<Object> it = DeferredUtils.flatUnpack(commandLine).iterator();
        Preconditions.checkArgument(it.hasNext(), "The command line must contain at least one element for the executable");
        Object executable = it.next();
        Preconditions.checkNotNull(executable, "The command line cannot contain null elements");
        ImmutableList.Builder arguments = ImmutableList.builder();
        it.forEachRemaining(element -> {
            Preconditions.checkNotNull(element, "The command line cannot contain null elements");
            arguments.add(element);
        });
        return new DefaultCommandLine(CommandLineTool.of(executable), CommandLineToolArguments.of((List<Object>)((Object)arguments.build())));
    }

    public static CommandLine script(Object ... commandLine) {
        return CommandLine.of(Arrays.asList(CommandLineUtils.getScriptCommandLine(), DeferredUtils.flatUnpack(Arrays.asList(commandLine)).stream().map(Object::toString).collect(Collectors.joining(" "))));
    }
}

