/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.utils;

import java.util.Optional;
import org.gradle.api.specs.Spec;

public final class SpecUtils {
    private SpecUtils() {
    }

    public static <T> Spec<T> byType(Class<? extends T> type) {
        return new ByTypeSpec<T>(type);
    }

    public static <T> Optional<Class<? extends T>> getTypeFiltered(Spec<T> spec) {
        if (spec instanceof ByTypeSpec) {
            return Optional.of(((ByTypeSpec)spec).getType());
        }
        return Optional.empty();
    }

    private static class ByTypeSpec<T>
    implements Spec<T> {
        private final Class<? extends T> type;

        public ByTypeSpec(Class<? extends T> type) {
            this.type = type;
        }

        public Class<? extends T> getType() {
            return this.type;
        }

        public boolean isSatisfiedBy(T t) {
            return this.type.isInstance(t);
        }

        public String toString() {
            return "SpecUtils.byType(" + this.type.getCanonicalName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ByTypeSpec)) {
                return false;
            }
            ByTypeSpec other = (ByTypeSpec)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<T> this$type = this.getType();
            Class<T> other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ByTypeSpec;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<T> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }
}

