/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.fixtures.file.FileSystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import java.util.function.BiFunction;

public interface GradleWrapperFixture {
    public File getTestDirectory();

    default public void writeGradleWrapperToTestDirectory() {
        GradleWrapperFixture.writeGradleWrapperTo(this.getTestDirectory());
    }

    default public void writeGradleWrapperToTestDirectory(String version) {
        Throwable throwable;
        GradleWrapperFixture.writeGradleWrapperTo(this.getTestDirectory());
        Properties wrapperProperties = new Properties();
        File wrapperPropertiesFile = new File(this.getTestDirectory(), "gradle/wrapper/gradle-wrapper.properties");
        try {
            throwable = null;
            try (FileInputStream inStream = new FileInputStream(wrapperPropertiesFile);){
                wrapperProperties.load(inStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Could not read '%s' because of an error.", wrapperPropertiesFile.getAbsolutePath()), e);
        }
        wrapperProperties.compute("distributionUrl", (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(key, oldValue) -> "https://services.gradle.org/distributions/gradle-" + version + "-bin.zip"));
        try {
            throwable = null;
            try (FileOutputStream outStream = new FileOutputStream(wrapperPropertiesFile);){
                wrapperProperties.store(outStream, null);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Could not write '%s' because of an error.", wrapperPropertiesFile.getAbsolutePath()), e);
        }
    }

    public static void writeGradleWrapperTo(File workingDirectory) {
        try {
            Files.copy(GradleWrapperFixture.class.getResourceAsStream("/dev/gradleplugins/fixtures/runnerkit/wrapper/gradlew"), FileSystemUtils.file((File)workingDirectory, (Object[])new Object[]{"gradlew"}).toPath(), StandardCopyOption.REPLACE_EXISTING);
            Files.copy(GradleWrapperFixture.class.getResourceAsStream("/dev/gradleplugins/fixtures/runnerkit/wrapper/gradlew.bat"), FileSystemUtils.file((File)workingDirectory, (Object[])new Object[]{"gradlew.bat"}).toPath(), StandardCopyOption.REPLACE_EXISTING);
            FileSystemUtils.file((File)workingDirectory, (Object[])new Object[]{"gradlew"}).setExecutable(true);
            FileSystemUtils.file((File)workingDirectory, (Object[])new Object[]{"gradle/wrapper"}).mkdirs();
            Files.copy(GradleWrapperFixture.class.getResourceAsStream("/dev/gradleplugins/fixtures/runnerkit/wrapper/gradle-wrapper.jar"), FileSystemUtils.file((File)workingDirectory, (Object[])new Object[]{"gradle/wrapper/gradle-wrapper.jar"}).toPath(), StandardCopyOption.REPLACE_EXISTING);
            Files.copy(GradleWrapperFixture.class.getResourceAsStream("/dev/gradleplugins/fixtures/runnerkit/wrapper/gradle-wrapper.properties"), FileSystemUtils.file((File)workingDirectory, (Object[])new Object[]{"gradle/wrapper/gradle-wrapper.properties"}).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

