/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.fixtures.file.FileSystemUtils;
import dev.gradleplugins.runnerkit.AbstractGradleExecutor;
import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.GradleExecutionResult;
import dev.gradleplugins.runnerkit.GradleExecutionResultNokeeExecImpl;
import dev.gradleplugins.runnerkit.GradleUserHomeLookup;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.distributions.WrapperAwareGradleDistribution;
import dev.gradleplugins.runnerkit.providers.GradleExecutionCommandLineProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionEnvironmentVariableProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionProvider;
import dev.nokee.core.exec.CommandLine;
import dev.nokee.core.exec.CommandLineToolExecutionResult;
import dev.nokee.core.exec.CommandLineToolInvocationEnvironmentVariables;
import dev.nokee.core.exec.CommandLineToolInvocationErrorOutputRedirect;
import dev.nokee.core.exec.CommandLineToolInvocationStandardOutputRedirect;
import dev.nokee.core.exec.ProcessBuilderEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;

final class GradleExecutorGradleWrapperImpl
extends AbstractGradleExecutor {
    GradleExecutorGradleWrapperImpl() {
    }

    protected GradleExecutionResult doRun(GradleExecutionContext parameters) {
        Throwable throwable;
        if (!(parameters.getDistribution().get() instanceof WrapperAwareGradleDistribution)) {
            throw new InvalidRunnerConfigurationException("The Gradle wrapper executor doesn't support customizing the distribution.");
        }
        if (!((List)parameters.getInjectedClasspath().get()).isEmpty()) {
            throw new InvalidRunnerConfigurationException("The Gradle wrapper executor doesn't support injected classpath.");
        }
        File workingDirectory = (File)parameters.getProjectDirectory().orElseGet(() -> ((GradleExecutionProvider)parameters.getWorkingDirectory()).get());
        Path relativePath = ((File)parameters.getGradleUserHomeDirectory().get()).toPath().relativize(GradleUserHomeLookup.gradleUserHome().toPath());
        Properties wrapperProperties = new Properties();
        try {
            throwable = null;
            try (FileInputStream inStream = new FileInputStream(FileSystemUtils.file((File)workingDirectory, (Object[])new Object[]{"gradle/wrapper/gradle-wrapper.properties"}));){
                wrapperProperties.load(inStream);
                wrapperProperties.setProperty("distributionPath", relativePath.toString() + "/wrapper/dists");
                wrapperProperties.setProperty("zipStorePath", relativePath.toString() + "/wrapper/dists");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            throwable = null;
            try (FileOutputStream outStream = new FileOutputStream(FileSystemUtils.file((File)workingDirectory, (Object[])new Object[]{"gradle/wrapper/gradle-wrapper.properties"}));){
                wrapperProperties.store(outStream, null);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        CommandLine command = null;
        command = SystemUtils.IS_OS_WINDOWS ? CommandLine.of(Arrays.asList("cmd", "/c", "gradlew.bat"), GradleExecutorGradleWrapperImpl.allArguments(parameters)) : CommandLine.of("./gradlew", GradleExecutorGradleWrapperImpl.allArguments(parameters));
        CommandLineToolExecutionResult result = command.newInvocation().withEnvironmentVariables(GradleExecutorGradleWrapperImpl.environmentVariables(parameters)).workingDirectory((File)parameters.getWorkingDirectory().get()).redirectStandardOutput(CommandLineToolInvocationStandardOutputRedirect.forwardTo((OutputStream)parameters.getStandardOutput().get())).redirectErrorOutput(CommandLineToolInvocationErrorOutputRedirect.forwardTo((OutputStream)parameters.getStandardError().get())).buildAndSubmit(new ProcessBuilderEngine()).waitFor();
        return new GradleExecutionResultNokeeExecImpl(result);
    }

    private static List<String> allArguments(GradleExecutionContext parameters) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-Dorg.gradle.jvmargs=" + GradleExecutorGradleWrapperImpl.getImplicitBuildJvmArgs().stream().map(it -> "'" + it + "'").collect(Collectors.joining(" ")));
        parameters.getExecutionParameters().stream().filter(GradleExecutionCommandLineProvider.class::isInstance).flatMap(GradleExecutorGradleWrapperImpl::asArguments).forEach(result::add);
        return result;
    }

    private static Stream<String> asArguments(GradleExecutionProvider<?> parameter) {
        return ((GradleExecutionCommandLineProvider)parameter).getAsArguments().stream();
    }

    private static CommandLineToolInvocationEnvironmentVariables environmentVariables(GradleExecutionContext parameters) {
        return parameters.getEnvironmentVariables().map(CommandLineToolInvocationEnvironmentVariables::from).orElse(CommandLineToolInvocationEnvironmentVariables.inherit()).plus(CommandLineToolInvocationEnvironmentVariables.from(((GradleExecutionEnvironmentVariableProvider)parameters.getJavaHome()).getAsEnvironmentVariables()));
    }
}

