/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Transformer;

public final class TransformerUtils {
    private TransformerUtils() {
    }

    public static <T> Transformer<T, T> noOpTransformer() {
        return NoOpTransformer.INSTANCE;
    }

    public static <T> Transformer<List<T>, Iterable<T>> toListTransformer() {
        return ToListTransformer.INSTANCE;
    }

    public static <T> Transformer<Set<T>, Iterable<T>> toSetTransformer() {
        return ToSetTransformer.INSTANCE;
    }

    public static <OUT, IN> Transformer<Set<OUT>, Iterable<IN>> toSetTransformer(Class<OUT> type) {
        return ToSetTransformer.INSTANCE;
    }

    public static <T, U> Transformer<T, U> constant(T value) {
        return new ConstantTransformer<T>(value);
    }

    public static <T> Transformer<T, T> configureInPlace(Action<? super T> action) {
        return new ConfigureInPlaceTransformer<T>(action);
    }

    private static final class ConfigureInPlaceTransformer<T>
    implements Transformer<T, T> {
        private final Action<? super T> action;

        public ConfigureInPlaceTransformer(Action<? super T> action) {
            this.action = action;
        }

        public T transform(T t) {
            this.action.execute(t);
            return t;
        }

        public String toString() {
            return "TransformerUtils.configureInPlace(" + this.action + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigureInPlaceTransformer)) {
                return false;
            }
            ConfigureInPlaceTransformer other = (ConfigureInPlaceTransformer)o;
            Action<T> this$action = this.action;
            Action<? super T> other$action = other.action;
            return !(this$action == null ? other$action != null : !this$action.equals(other$action));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Action<T> $action = this.action;
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            return result;
        }
    }

    private static final class ConstantTransformer<T>
    implements Transformer<T, Object> {
        private final T value;

        public ConstantTransformer(T value) {
            this.value = value;
        }

        public T transform(Object o) {
            return this.value;
        }

        public String toString() {
            return "TransformerUtils.constant(" + this.value + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstantTransformer)) {
                return false;
            }
            ConstantTransformer other = (ConstantTransformer)o;
            T this$value = this.value;
            T other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }

    private static enum ToSetTransformer implements Transformer<Set<? extends Object>, Iterable<? extends Object>>
    {
        INSTANCE;


        public Set<?> transform(Iterable<?> objects) {
            return ImmutableSet.copyOf(objects);
        }

        public String toString() {
            return "TransformerUtils.toSetTransformer()";
        }
    }

    private static enum ToListTransformer implements Transformer<List<? extends Object>, Iterable<? extends Object>>
    {
        INSTANCE;


        public List<?> transform(Iterable<?> objects) {
            return ImmutableList.copyOf(objects);
        }

        public String toString() {
            return "TransformerUtils.toListTransformer()";
        }
    }

    private static enum NoOpTransformer implements Transformer<Object, Object>
    {
        INSTANCE;


        public Object transform(Object o) {
            return o;
        }

        public String toString() {
            return "TransformerUtils.noOpTransformer()";
        }
    }
}

