/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.ansi.html;

import net.rubygrapefruit.ansi.TextAttributes;
import net.rubygrapefruit.ansi.TextColor;
import net.rubygrapefruit.ansi.Visitor;
import net.rubygrapefruit.ansi.token.BackgroundColor;
import net.rubygrapefruit.ansi.token.BoldOff;
import net.rubygrapefruit.ansi.token.BoldOn;
import net.rubygrapefruit.ansi.token.CarriageReturn;
import net.rubygrapefruit.ansi.token.ForegroundColor;
import net.rubygrapefruit.ansi.token.NewLine;
import net.rubygrapefruit.ansi.token.Text;
import net.rubygrapefruit.ansi.token.Token;
import net.rubygrapefruit.ansi.token.UnrecognizedControlSequence;

public class HtmlFormatter
implements Visitor {
    private final StringBuilder content = new StringBuilder();
    private TextAttributes attributes = TextAttributes.NORMAL;
    private boolean spanHasContent;

    public HtmlFormatter() {
        this.content.append("<!DOCTYPE html>\n<head>\n<meta charset='UTF-8'>\n<style>");
        this.content.append("pre { font-family: monospace; font-size: 11pt; }\n");
        this.content.append(".ansi-bold { font-weight: bold; }\n");
        this.content.append(".ansi-unknown-sequence { color: white; background: red; }\n");
        this.content.append(".ansi-sequence { color: black; background: #c0c0c0; }\n");
        this.appendColorStyle(this.content, TextColor.BLACK, "rgb(0,0,0)", "rgb(102,102,102)");
        this.appendColorStyle(this.content, TextColor.RED, "rgb(153,0,0)", "rgb(229,0,0)");
        this.appendColorStyle(this.content, TextColor.GREEN, "rgb(0,166,0)", "rgb(0,217,0)");
        this.appendColorStyle(this.content, TextColor.YELLOW, "rgb(153,153,0)", "rgb(229,229,0)");
        this.appendColorStyle(this.content, TextColor.BLUE, "rgb(0,0,178)", "rgb(0,0,255)");
        this.appendColorStyle(this.content, TextColor.MAGENTA, "rgb(178,0,178)", "rgb(229,0,229)");
        this.appendColorStyle(this.content, TextColor.CYAN, "rgb(0,166,178)", "rgb(0,229,229)");
        this.appendColorStyle(this.content, TextColor.WHITE, "rgb(191,191,191)", "rgb(229,229,229)");
        this.content.append("</style>\n</head>\n<body>\n<pre>");
    }

    private void appendColorStyle(StringBuilder content, TextColor color, String cssValue, String brightCssValue) {
        content.append(".ansi-").append(color.getName()).append(" { color: ").append(cssValue).append("; }\n");
        content.append(".ansi-bright-").append(color.getName()).append(" { color: ").append(brightCssValue).append("; }\n");
        content.append(".ansi-").append(color.getName()).append("-bg { background: ").append(cssValue).append("; }\n");
        content.append(".ansi-bright-").append(color.getName()).append("-bg { background: ").append(brightCssValue).append("; }\n");
    }

    public String toHtml() {
        this.endCurrentSpan();
        return this.content + "</pre>\n</body>\n</html>";
    }

    @Override
    public void visit(Token token) {
        if (token instanceof Text) {
            Text text = (Text)token;
            this.appendText(text.getText());
        } else if (token instanceof NewLine) {
            this.appendText("\n");
        } else if (token instanceof CarriageReturn) {
            this.appendText("\r");
        } else if (token instanceof BoldOn) {
            if (this.attributes.isBold()) {
                return;
            }
            this.endCurrentSpan();
            this.attributes = this.attributes.boldOn();
        } else if (token instanceof BoldOff) {
            if (!this.attributes.isBold()) {
                return;
            }
            this.endCurrentSpan();
            this.attributes = this.attributes.boldOff();
        } else if (token instanceof ForegroundColor) {
            ForegroundColor foregroundColor = (ForegroundColor)token;
            if (this.attributes.getColor().equals(foregroundColor.getColor())) {
                return;
            }
            this.endCurrentSpan();
            this.attributes = this.attributes.color(foregroundColor.getColor());
        } else if (token instanceof BackgroundColor) {
            BackgroundColor backgroundColor = (BackgroundColor)token;
            if (this.attributes.getBackground().equals(backgroundColor.getColor())) {
                return;
            }
            this.endCurrentSpan();
            this.attributes = this.attributes.background(backgroundColor.getColor());
        } else if (token instanceof UnrecognizedControlSequence) {
            this.endCurrentSpan();
            this.content.append("<span class='ansi-unknown-sequence'>");
            token.appendDiagnostic(this.content);
            this.content.append("</span>");
        } else {
            this.endCurrentSpan();
            this.content.append("<span class='ansi-sequence'>");
            token.appendDiagnostic(this.content);
            this.content.append("</span>");
        }
    }

    private void endCurrentSpan() {
        if (this.spanHasContent && !this.attributes.equals(TextAttributes.NORMAL)) {
            this.content.append("</span>");
        }
        this.spanHasContent = false;
    }

    private void appendText(String chars) {
        if (!this.spanHasContent && !this.attributes.equals(TextAttributes.NORMAL)) {
            this.content.append("<span class='");
            boolean hasClass = false;
            if (this.attributes.isBold()) {
                this.content.append("ansi-bold");
                hasClass = true;
            }
            if (!this.attributes.getColor().isDefault()) {
                if (!hasClass) {
                    hasClass = true;
                } else {
                    this.content.append(' ');
                }
                this.appendColorClass(this.content, this.attributes.getColor());
            }
            if (!this.attributes.getBackground().isDefault()) {
                if (hasClass) {
                    this.content.append(' ');
                }
                this.appendColorClass(this.content, this.attributes.getBackground());
                this.content.append("-bg");
            }
            this.content.append("'>");
        }
        for (int i = 0; i < chars.length(); ++i) {
            char ch = chars.charAt(i);
            if (ch == '<') {
                this.content.append("&lt;");
                continue;
            }
            this.content.append(ch);
        }
        this.spanHasContent = true;
    }

    private void appendColorClass(StringBuilder content, TextColor foreground) {
        content.append("ansi-");
        if (foreground.isBright()) {
            content.append("bright-");
        }
        content.append(foreground.getName());
    }
}

